package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import cn.ibizlab.core.sample.domain.IBIZHardware;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSTORAGE", resultMap = "IBIZStorageResultMap")
@ApiModel(value = "IBIZSTORAGE", description = "存储")
public class IBIZStorage extends EntityMP implements Serializable
{

    /**
     * 存储标识
     */
    @Id
    @TableId(value = "ibizstorageid" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizstorageid" , isKeyField = true)
    @JsonProperty("ibizstorageid")
    @JSONField(name = "ibizstorageid")
    @ApiModelProperty(value = "ibizstorageid", notes = "存储标识")
    private String ibizStorageId;

    /**
     * 生产厂商
     */
    @TableField(value = "producer" , exist = false)
    @DEField(name = "producer")
    @JsonProperty("producer")
    @JSONField(name = "producer")
    @ApiModelProperty(value = "producer", notes = "生产厂商")
    private String producer;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 单位
     */
    @TableField(value = "unit" , exist = false)
    @DEField(name = "unit")
    @JsonProperty("unit")
    @JSONField(name = "unit")
    @ApiModelProperty(value = "unit", notes = "单位")
    private String unit;

    /**
     * 分组类型
     */
    @TableField(value = "ibizhardwaretype" , exist = false)
    @DEField(name = "ibizhardwaretype" , dict = "HARDWARETYPE")
    @JsonProperty("ibizhardwaretype")
    @JSONField(name = "ibizhardwaretype")
    @ApiModelProperty(value = "ibizhardwaretype", notes = "分组类型")
    private String ibizHardwareType;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 产品编号
     */
    @TableField(value = "productuid" , exist = false)
    @DEField(name = "productuid")
    @JsonProperty("productuid")
    @JSONField(name = "productuid")
    @ApiModelProperty(value = "productuid", notes = "产品编号")
    private String productUid;

    /**
     * 单价
     */
    @TableField(value = "unitprice" , exist = false)
    @DEField(name = "unitprice")
    @JsonProperty("unitprice")
    @JSONField(name = "unitprice")
    @ApiModelProperty(value = "unitprice", notes = "单价")
    private BigDecimal unitPrice;

    /**
     * 存储名称
     */
    @TableField(value = "ibizstoragename")
    @DEField(name = "ibizstoragename")
    @JsonProperty("ibizstoragename")
    @JSONField(name = "ibizstoragename")
    @ApiModelProperty(value = "ibizstoragename", notes = "存储名称")
    private String ibizStorageName;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;





    /**
     * 设置 [生产厂商]
     */
    public void setProducer(String producer) {
        this.producer = producer;
        this.modify("producer", producer);
    }


    /**
     * 设置 [单位]
     */
    public void setUnit(String unit) {
        this.unit = unit;
        this.modify("unit", unit);
    }

    /**
     * 设置 [分组类型]
     */
    public void setIbizHardwareType(String ibizHardwareType) {
        this.ibizHardwareType = ibizHardwareType;
        this.modify("ibizhardwaretype", ibizHardwareType);
    }



    /**
     * 设置 [产品编号]
     */
    public void setProductUid(String productUid) {
        this.productUid = productUid;
        this.modify("productuid", productUid);
    }

    /**
     * 设置 [单价]
     */
    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        this.modify("unitprice", unitPrice);
    }

    /**
     * 设置 [存储名称]
     */
    public void setIbizStorageName(String ibizStorageName) {
        this.ibizStorageName = ibizStorageName;
        this.modify("ibizstoragename", ibizStorageName);
    }




    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizstorageid");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}