package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import cn.ibizlab.core.sample.domain.IBIZSample0014;
import cn.ibizlab.core.sample.domain.IBIZSample0015;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0016", resultMap = "IBIZSample0016ResultMap")
@ApiModel(value = "IBIZSAMPLE0016", description = "项目成员")
public class IBIZSample0016 extends EntityMP implements Serializable
{

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 项目成员标识
     */
    @Id
    @TableId(value = "ibizsample0016id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0016id" , isKeyField = true)
    @JsonProperty("ibizsample0016id")
    @JSONField(name = "ibizsample0016id")
    @ApiModelProperty(value = "ibizsample0016id", notes = "项目成员标识")
    private String ibizSample0016Id;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 项目成员名称
     */
    @TableField(value = "ibizsample0016name")
    @DEField(name = "ibizsample0016name")
    @JsonProperty("ibizsample0016name")
    @JSONField(name = "ibizsample0016name")
    @ApiModelProperty(value = "ibizsample0016name", notes = "项目成员名称")
    private String ibizSample0016Name;

    /**
     * 项目名称
     */
    @TableField(value = "ibizsample0015name" , exist = false)
    @DEField(name = "ibizsample0015name")
    @JsonProperty("ibizsample0015name")
    @JSONField(name = "ibizsample0015name")
    @ApiModelProperty(value = "ibizsample0015name", notes = "项目名称")
    private String ibizSample0015Name;

    /**
     * 员工名称
     */
    @TableField(value = "ibizsample0014name" , exist = false)
    @DEField(name = "ibizsample0014name")
    @JsonProperty("ibizsample0014name")
    @JSONField(name = "ibizsample0014name")
    @ApiModelProperty(value = "ibizsample0014name", notes = "员工名称")
    private String ibizSample0014Name;

    /**
     * 项目标识
     */
    @TableField(value = "ibizsample0015id")
    @DEField(name = "ibizsample0015id")
    @JsonProperty("ibizsample0015id")
    @JSONField(name = "ibizsample0015id")
    @ApiModelProperty(value = "ibizsample0015id", notes = "项目标识")
    private String ibizSample0015Id;

    /**
     * 员工标识
     */
    @TableField(value = "ibizsample0014id")
    @DEField(name = "ibizsample0014id")
    @JsonProperty("ibizsample0014id")
    @JSONField(name = "ibizsample0014id")
    @ApiModelProperty(value = "ibizsample0014id", notes = "员工标识")
    private String ibizSample0014Id;


    /**
     * 员工
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    @ApiModelProperty(value = "ibizsample0014", notes = "")
    private IBIZSample0014 ibizsample0014;
    /**
     * 项目
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    @ApiModelProperty(value = "ibizsample0015", notes = "")
    private IBIZSample0015 ibizsample0015;







    /**
     * 设置 [项目成员名称]
     */
    public void setIbizSample0016Name(String ibizSample0016Name) {
        this.ibizSample0016Name = ibizSample0016Name;
        this.modify("ibizsample0016name", ibizSample0016Name);
    }

    /**
     * 设置 [项目名称]
     */
    public void setIbizSample0015Name(String ibizSample0015Name) {
        this.ibizSample0015Name = ibizSample0015Name;
        this.modify("ibizsample0015name", ibizSample0015Name);
    }

    /**
     * 设置 [员工名称]
     */
    public void setIbizSample0014Name(String ibizSample0014Name) {
        this.ibizSample0014Name = ibizSample0014Name;
        this.modify("ibizsample0014name", ibizSample0014Name);
    }

    /**
     * 设置 [项目标识]
     */
    public void setIbizSample0015Id(String ibizSample0015Id) {
        this.ibizSample0015Id = ibizSample0015Id;
        this.modify("ibizsample0015id", ibizSample0015Id);
    }

    /**
     * 设置 [员工标识]
     */
    public void setIbizSample0014Id(String ibizSample0014Id) {
        this.ibizSample0014Id = ibizSample0014Id;
        this.modify("ibizsample0014id", ibizSample0014Id);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0016id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}