package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import cn.ibizlab.core.sample.domain.IBIZCustomer;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "IBIZCUSTOMERMG", resultMap = "IBIZCustomerMGResultMap")
@ApiModel(value = "IBIZCUSTOMERMG", description = "客户管理")
public class IBIZCustomerMG extends EntityMP implements Serializable
{

    /**
     * 客户标识
     */
    @Id
    @TableField(exist = false)
    @DEField(name = "ibizcustomerid" , isKeyField = true)
    @JsonProperty("ibizcustomerid")
    @JSONField(name = "ibizcustomerid")
    @ApiModelProperty(value = "ibizcustomerid", notes = "客户标识")
    private String ibizCustomerId;

    /**
     * 客户名称
     */
    @TableField(value = "ibizcustomername" , exist = false)
    @DEField(name = "ibizcustomername")
    @JsonProperty("ibizcustomername")
    @JSONField(name = "ibizcustomername")
    @ApiModelProperty(value = "ibizcustomername", notes = "客户名称")
    private String ibizCustomerName;

    /**
     * 开户银行号
     */
    @TableField(value = "bankaccountnum" , exist = false)
    @DEField(name = "bankaccountnum")
    @JsonProperty("bankaccountnum")
    @JSONField(name = "bankaccountnum")
    @ApiModelProperty(value = "bankaccountnum", notes = "开户银行号")
    private String bankAccountNum;

    /**
     * 开户行
     */
    @TableField(value = "bankname" , exist = false)
    @DEField(name = "bankname")
    @JsonProperty("bankname")
    @JSONField(name = "bankname")
    @ApiModelProperty(value = "bankname", notes = "开户行")
    private String bankName;

    /**
     * 公司地址
     */
    @TableField(value = "address" , exist = false)
    @DEField(name = "address")
    @JsonProperty("address")
    @JSONField(name = "address")
    @ApiModelProperty(value = "address", notes = "公司地址")
    private String address;

    /**
     * 客户编号
     */
    @TableField(value = "customeruid" , exist = false)
    @DEField(name = "customeruid")
    @JsonProperty("customeruid")
    @JSONField(name = "customeruid")
    @ApiModelProperty(value = "customeruid", notes = "客户编号")
    private String customerUid;





    /**
     * 设置 [客户名称]
     */
    public void setIbizCustomerName(String ibizCustomerName) {
        this.ibizCustomerName = ibizCustomerName;
        this.modify("ibizcustomername", ibizCustomerName);
    }

    /**
     * 设置 [开户银行号]
     */
    public void setBankAccountNum(String bankAccountNum) {
        this.bankAccountNum = bankAccountNum;
        this.modify("bankaccountnum", bankAccountNum);
    }

    /**
     * 设置 [开户行]
     */
    public void setBankName(String bankName) {
        this.bankName = bankName;
        this.modify("bankname", bankName);
    }

    /**
     * 设置 [公司地址]
     */
    public void setAddress(String address) {
        this.address = address;
        this.modify("address", address);
    }

    /**
     * 设置 [客户编号]
     */
    public void setCustomerUid(String customerUid) {
        this.customerUid = customerUid;
        this.modify("customeruid", customerUid);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizcustomerid");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}