package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0021;
import cn.ibizlab.core.sample.service.IBIZSample0021Service;
import cn.ibizlab.core.sample.filter.IBIZSample0021SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单" })
@RestController("demoapi-ibizsample0021")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0021Resource {

    @Autowired
    public IBIZSample0021Service ibizSample0021Service;

    @Autowired
    @Lazy
    public IBIZSample0021DTOMapping ibizSample0021DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"订单" },  notes = "IBIZSample0021-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0021-Create-all') or hasPermission(this.ibizSample0021DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0021-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0021s")
    public ResponseEntity<IBIZSample0021DTO> create
            (@Validated @RequestBody IBIZSample0021DTO dto) {
        IBIZSample0021 domain = ibizSample0021DtoMapping.toDomain(dto);
        ibizSample0021Service.create(domain);
        IBIZSample0021 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0021DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"订单" },  notes = "IBIZSample0021-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0021-Get-all') or hasPermission(this.ibizSample0021DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0021-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0021s/{ibizSample0021Id}")
    public ResponseEntity<IBIZSample0021DTO> getByIbizSample0021Id
            (@PathVariable("ibizSample0021Id") String ibizSample0021Id) {
        IBIZSample0021 rt = ibizSample0021Service.get(ibizSample0021Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0021DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"订单" },  notes = "IBIZSample0021-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0021-Remove-all') or hasPermission(this.ibizSample0021Service.get(#ibizSample0021Id),'DemoSys-IBIZSample0021-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0021s/{ibizSample0021Id}")
    public ResponseEntity<Boolean> removeByIbizSample0021Id
            (@PathVariable("ibizSample0021Id") String ibizSample0021Id) {
        Boolean rt = ibizSample0021Service.remove(ibizSample0021Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"订单" },  notes = "IBIZSample0021-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0021-Update-all') or hasPermission(this.ibizSample0021Service.get(#ibizSample0021Id),'DemoSys-IBIZSample0021-Update')")
    @VersionCheck(entity = "ibizsample0021" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0021s/{ibizSample0021Id}")
    public ResponseEntity<IBIZSample0021DTO> updateByIbizSample0021Id
            (@PathVariable("ibizSample0021Id") String ibizSample0021Id, @Validated @RequestBody IBIZSample0021DTO dto) {
        IBIZSample0021 domain = ibizSample0021DtoMapping.toDomain(dto);
        domain.setIbizSample0021Id(ibizSample0021Id);
        ibizSample0021Service.update(domain);
        IBIZSample0021 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0021DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"订单" },  notes = "IBIZSample0021-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0021s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0021DTO dto) {
        IBIZSample0021 domain = ibizSample0021DtoMapping.toDomain(dto);
        Integer rt = ibizSample0021Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"订单" },  notes = "IBIZSample0021-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0021s/getdraft")
    public ResponseEntity<IBIZSample0021DTO> getDraft
            (IBIZSample0021DTO dto) {
        IBIZSample0021 domain = ibizSample0021DtoMapping.toDomain(dto);
        IBIZSample0021 rt = ibizSample0021Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0021DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"订单" },  notes = "IBIZSample0021-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0021-Save-all') or hasPermission(this.ibizSample0021DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0021-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0021s/save")
    public ResponseEntity<IBIZSample0021DTO> save
            (@Validated @RequestBody IBIZSample0021DTO dto) {
        IBIZSample0021 domain = ibizSample0021DtoMapping.toDomain(dto);
        ibizSample0021Service.save(domain);
        IBIZSample0021 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0021DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"订单" },  notes = "IBIZSample0021-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0021-searchDefault-all','DemoSys-IBIZSample0021-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0021-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0021s/fetchdefault")
    public ResponseEntity<List<IBIZSample0021DTO>> fetchDefault
            (IBIZSample0021SearchContext dto) {
        Page<IBIZSample0021> domains = ibizSample0021Service.searchDefault(dto) ;
        List<IBIZSample0021DTO> list = ibizSample0021DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0021-Create-all')")
    @ApiOperation(value = "批量新建订单", tags = {"订单" },  notes = "批量新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0021s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0021DTO> dtos) {
        ibizSample0021Service.createBatch(ibizSample0021DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0021-Update-all')")
    @ApiOperation(value = "批量更新订单", tags = {"订单" },  notes = "批量更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0021s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0021DTO> dtos) {
        ibizSample0021Service.updateBatch(ibizSample0021DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0021-Save-all')")
    @ApiOperation(value = "批量保存订单", tags = {"订单" },  notes = "批量保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0021s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0021DTO> dtos) {
        ibizSample0021Service.saveBatch(ibizSample0021DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0021-Save-all')")
    @ApiOperation(value = "批量导入订单", tags = {"订单" },  notes = "批量导入订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0021s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0021DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0021> list=ibizSample0021DtoMapping.toDomain(dtos);
            List<IBIZSample0021> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0021Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0021-Remove-all')")
    @ApiOperation(value = "批量删除订单", tags = {"订单" },  notes = "批量删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0021s","/ibizsample0021s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0021Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
