package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0018;
import cn.ibizlab.core.sample.service.IBIZSample0018Service;
import cn.ibizlab.core.sample.filter.IBIZSample0018SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"示例实体18" })
@RestController("demoapi-ibizsample0018")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0018Resource {

    @Autowired
    public IBIZSample0018Service ibizSample0018Service;

    @Autowired
    @Lazy
    public IBIZSample0018DTOMapping ibizSample0018DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"示例实体18" },  notes = "IBIZSample0018-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0018-Create-all') or hasPermission(this.ibizSample0018DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0018-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0018s")
    public ResponseEntity<IBIZSample0018DTO> create
            (@Validated @RequestBody IBIZSample0018DTO dto) {
        IBIZSample0018 domain = ibizSample0018DtoMapping.toDomain(dto);
        ibizSample0018Service.create(domain);
        IBIZSample0018 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0018DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"示例实体18" },  notes = "IBIZSample0018-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0018-Get-all') or hasPermission(this.ibizSample0018DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0018-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0018s/{ibizSample0018Id}")
    public ResponseEntity<IBIZSample0018DTO> getByIbizSample0018Id
            (@PathVariable("ibizSample0018Id") String ibizSample0018Id) {
        IBIZSample0018 rt = ibizSample0018Service.get(ibizSample0018Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0018DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"示例实体18" },  notes = "IBIZSample0018-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0018-Remove-all') or hasPermission(this.ibizSample0018Service.get(#ibizSample0018Id),'DemoSys-IBIZSample0018-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0018s/{ibizSample0018Id}")
    public ResponseEntity<Boolean> removeByIbizSample0018Id
            (@PathVariable("ibizSample0018Id") String ibizSample0018Id) {
        Boolean rt = ibizSample0018Service.remove(ibizSample0018Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"示例实体18" },  notes = "IBIZSample0018-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0018-Update-all') or hasPermission(this.ibizSample0018Service.get(#ibizSample0018Id),'DemoSys-IBIZSample0018-Update')")
    @VersionCheck(entity = "ibizsample0018" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0018s/{ibizSample0018Id}")
    public ResponseEntity<IBIZSample0018DTO> updateByIbizSample0018Id
            (@PathVariable("ibizSample0018Id") String ibizSample0018Id, @Validated @RequestBody IBIZSample0018DTO dto) {
        IBIZSample0018 domain = ibizSample0018DtoMapping.toDomain(dto);
        domain.setIbizSample0018Id(ibizSample0018Id);
        ibizSample0018Service.update(domain);
        IBIZSample0018 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0018DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"示例实体18" },  notes = "IBIZSample0018-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0018s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0018DTO dto) {
        IBIZSample0018 domain = ibizSample0018DtoMapping.toDomain(dto);
        Integer rt = ibizSample0018Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"示例实体18" },  notes = "IBIZSample0018-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0018s/getdraft")
    public ResponseEntity<IBIZSample0018DTO> getDraft
            (IBIZSample0018DTO dto) {
        IBIZSample0018 domain = ibizSample0018DtoMapping.toDomain(dto);
        IBIZSample0018 rt = ibizSample0018Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0018DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"示例实体18" },  notes = "IBIZSample0018-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0018-Save-all') or hasPermission(this.ibizSample0018DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0018-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0018s/save")
    public ResponseEntity<IBIZSample0018DTO> save
            (@Validated @RequestBody IBIZSample0018DTO dto) {
        IBIZSample0018 domain = ibizSample0018DtoMapping.toDomain(dto);
        ibizSample0018Service.save(domain);
        IBIZSample0018 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0018DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"示例实体18" },  notes = "IBIZSample0018-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0018-searchDefault-all','DemoSys-IBIZSample0018-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0018-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0018s/fetchdefault")
    public ResponseEntity<List<IBIZSample0018DTO>> fetchDefault
            (IBIZSample0018SearchContext dto) {
        Page<IBIZSample0018> domains = ibizSample0018Service.searchDefault(dto) ;
        List<IBIZSample0018DTO> list = ibizSample0018DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0018-Create-all')")
    @ApiOperation(value = "批量新建示例实体18", tags = {"示例实体18" },  notes = "批量新建示例实体18")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0018s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0018DTO> dtos) {
        ibizSample0018Service.createBatch(ibizSample0018DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0018-Update-all')")
    @ApiOperation(value = "批量更新示例实体18", tags = {"示例实体18" },  notes = "批量更新示例实体18")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0018s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0018DTO> dtos) {
        ibizSample0018Service.updateBatch(ibizSample0018DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0018-Save-all')")
    @ApiOperation(value = "批量保存示例实体18", tags = {"示例实体18" },  notes = "批量保存示例实体18")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0018s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0018DTO> dtos) {
        ibizSample0018Service.saveBatch(ibizSample0018DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0018-Save-all')")
    @ApiOperation(value = "批量导入示例实体18", tags = {"示例实体18" },  notes = "批量导入示例实体18")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0018s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0018DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0018> list=ibizSample0018DtoMapping.toDomain(dtos);
            List<IBIZSample0018> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0018Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0018-Remove-all')")
    @ApiOperation(value = "批量删除示例实体18", tags = {"示例实体18" },  notes = "批量删除示例实体18")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0018s","/ibizsample0018s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0018Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
