package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0010;
import cn.ibizlab.core.sample.service.IBIZSample0010Service;
import cn.ibizlab.core.sample.filter.IBIZSample0010SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单" })
@RestController("demoapi-ibizsample0010")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0010Resource {

    @Autowired
    public IBIZSample0010Service ibizSample0010Service;

    @Autowired
    @Lazy
    public IBIZSample0010DTOMapping ibizSample0010DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"订单" },  notes = "IBIZSample0010-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0010-Create-all') or hasPermission(this.ibizSample0010DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0010-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0010s")
    public ResponseEntity<IBIZSample0010DTO> create
            (@Validated @RequestBody IBIZSample0010DTO dto) {
        IBIZSample0010 domain = ibizSample0010DtoMapping.toDomain(dto);
        ibizSample0010Service.create(domain);
        IBIZSample0010 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0010DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"订单" },  notes = "IBIZSample0010-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0010-Get-all') or hasPermission(this.ibizSample0010DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0010-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0010s/{ibizSample0010Id}")
    public ResponseEntity<IBIZSample0010DTO> getByIbizSample0010Id
            (@PathVariable("ibizSample0010Id") String ibizSample0010Id) {
        IBIZSample0010 rt = ibizSample0010Service.get(ibizSample0010Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0010DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"订单" },  notes = "IBIZSample0010-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0010-Remove-all') or hasPermission(this.ibizSample0010Service.get(#ibizSample0010Id),'DemoSys-IBIZSample0010-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0010s/{ibizSample0010Id}")
    public ResponseEntity<Boolean> removeByIbizSample0010Id
            (@PathVariable("ibizSample0010Id") String ibizSample0010Id) {
        Boolean rt = ibizSample0010Service.remove(ibizSample0010Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"订单" },  notes = "IBIZSample0010-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0010-Update-all') or hasPermission(this.ibizSample0010Service.get(#ibizSample0010Id),'DemoSys-IBIZSample0010-Update')")
    @VersionCheck(entity = "ibizsample0010" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0010s/{ibizSample0010Id}")
    public ResponseEntity<IBIZSample0010DTO> updateByIbizSample0010Id
            (@PathVariable("ibizSample0010Id") String ibizSample0010Id, @Validated @RequestBody IBIZSample0010DTO dto) {
        IBIZSample0010 domain = ibizSample0010DtoMapping.toDomain(dto);
        domain.setIbizSample0010Id(ibizSample0010Id);
        ibizSample0010Service.update(domain);
        IBIZSample0010 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0010DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"订单" },  notes = "IBIZSample0010-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0010s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0010DTO dto) {
        IBIZSample0010 domain = ibizSample0010DtoMapping.toDomain(dto);
        Integer rt = ibizSample0010Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"订单" },  notes = "IBIZSample0010-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0010s/getdraft")
    public ResponseEntity<IBIZSample0010DTO> getDraft
            (IBIZSample0010DTO dto) {
        IBIZSample0010 domain = ibizSample0010DtoMapping.toDomain(dto);
        IBIZSample0010 rt = ibizSample0010Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0010DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"订单" },  notes = "IBIZSample0010-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0010-Save-all') or hasPermission(this.ibizSample0010DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0010-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0010s/save")
    public ResponseEntity<IBIZSample0010DTO> save
            (@Validated @RequestBody IBIZSample0010DTO dto) {
        IBIZSample0010 domain = ibizSample0010DtoMapping.toDomain(dto);
        ibizSample0010Service.save(domain);
        IBIZSample0010 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0010DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"订单" },  notes = "IBIZSample0010-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0010-searchDefault-all','DemoSys-IBIZSample0010-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0010-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0010s/fetchdefault")
    public ResponseEntity<List<IBIZSample0010DTO>> fetchDefault
            (IBIZSample0010SearchContext dto) {
        Page<IBIZSample0010> domains = ibizSample0010Service.searchDefault(dto) ;
        List<IBIZSample0010DTO> list = ibizSample0010DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0010-Create-all')")
    @ApiOperation(value = "批量新建订单", tags = {"订单" },  notes = "批量新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0010s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0010DTO> dtos) {
        ibizSample0010Service.createBatch(ibizSample0010DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0010-Update-all')")
    @ApiOperation(value = "批量更新订单", tags = {"订单" },  notes = "批量更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0010s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0010DTO> dtos) {
        ibizSample0010Service.updateBatch(ibizSample0010DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0010-Save-all')")
    @ApiOperation(value = "批量保存订单", tags = {"订单" },  notes = "批量保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0010s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0010DTO> dtos) {
        ibizSample0010Service.saveBatch(ibizSample0010DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0010-Save-all')")
    @ApiOperation(value = "批量导入订单", tags = {"订单" },  notes = "批量导入订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0010s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0010DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0010> list=ibizSample0010DtoMapping.toDomain(dtos);
            List<IBIZSample0010> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0010Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0010-Remove-all')")
    @ApiOperation(value = "批量删除订单", tags = {"订单" },  notes = "批量删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0010s","/ibizsample0010s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0010Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
