package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.DYNADASHBOARD;
import cn.ibizlab.core.sample.service.DYNADASHBOARDService;
import cn.ibizlab.core.sample.filter.DYNADASHBOARDSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"动态数据看板" })
@RestController("demoapi-dynadashboard")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class DYNADASHBOARDResource {

    @Autowired
    public DYNADASHBOARDService dynadashboardService;

    @Autowired
    @Lazy
    public DYNADASHBOARDDTOMapping dynadashboarddtoMapping;


    @ApiOperation(value = "创建Create", tags = {"动态数据看板" },  notes = "DYNADASHBOARD-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-DYNADASHBOARD-Create-all') or hasPermission(this.dynadashboarddtoMapping.toDomain(#dto),'DemoSys-DYNADASHBOARD-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "dynadashboards")
    public ResponseEntity<DYNADASHBOARDDTO> create
            (@Validated @RequestBody DYNADASHBOARDDTO dto) {
        DYNADASHBOARD domain = dynadashboarddtoMapping.toDomain(dto);
        dynadashboardService.create(domain);
        DYNADASHBOARD rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(dynadashboarddtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"动态数据看板" },  notes = "DYNADASHBOARD-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-DYNADASHBOARD-Get-all') or hasPermission(this.dynadashboarddtoMapping.toDomain(returnObject.body),'DemoSys-DYNADASHBOARD-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "dynadashboards/{dynadashboardid}")
    public ResponseEntity<DYNADASHBOARDDTO> getByDynadashboardid
            (@PathVariable("dynadashboardid") String dynadashboardid) {
        DYNADASHBOARD rt = dynadashboardService.get(dynadashboardid);
        return ResponseEntity.status(HttpStatus.OK).body(dynadashboarddtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"动态数据看板" },  notes = "DYNADASHBOARD-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-DYNADASHBOARD-Remove-all') or hasPermission(this.dynadashboardService.get(#dynadashboardid),'DemoSys-DYNADASHBOARD-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "dynadashboards/{dynadashboardid}")
    public ResponseEntity<Boolean> removeByDynadashboardid
            (@PathVariable("dynadashboardid") String dynadashboardid) {
        Boolean rt = dynadashboardService.remove(dynadashboardid);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"动态数据看板" },  notes = "DYNADASHBOARD-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-DYNADASHBOARD-Update-all') or hasPermission(this.dynadashboardService.get(#dynadashboardid),'DemoSys-DYNADASHBOARD-Update')")
    @VersionCheck(entity = "dynadashboard" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "dynadashboards/{dynadashboardid}")
    public ResponseEntity<DYNADASHBOARDDTO> updateByDynadashboardid
            (@PathVariable("dynadashboardid") String dynadashboardid, @Validated @RequestBody DYNADASHBOARDDTO dto) {
        DYNADASHBOARD domain = dynadashboarddtoMapping.toDomain(dto);
        domain.setDynadashboardid(dynadashboardid);
        dynadashboardService.update(domain);
        DYNADASHBOARD rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(dynadashboarddtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"动态数据看板" },  notes = "DYNADASHBOARD-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "dynadashboards/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody DYNADASHBOARDDTO dto) {
        DYNADASHBOARD domain = dynadashboarddtoMapping.toDomain(dto);
        Integer rt = dynadashboardService.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"动态数据看板" },  notes = "DYNADASHBOARD-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "dynadashboards/getdraft")
    public ResponseEntity<DYNADASHBOARDDTO> getDraft
            (DYNADASHBOARDDTO dto) {
        DYNADASHBOARD domain = dynadashboarddtoMapping.toDomain(dto);
        DYNADASHBOARD rt = dynadashboardService.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dynadashboarddtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"动态数据看板" },  notes = "DYNADASHBOARD-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-DYNADASHBOARD-Save-all') or hasPermission(this.dynadashboarddtoMapping.toDomain(#dto),'DemoSys-DYNADASHBOARD-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "dynadashboards/save")
    public ResponseEntity<DYNADASHBOARDDTO> save
            (@Validated @RequestBody DYNADASHBOARDDTO dto) {
        DYNADASHBOARD domain = dynadashboarddtoMapping.toDomain(dto);
        dynadashboardService.save(domain);
        DYNADASHBOARD rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(dynadashboarddtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"动态数据看板" },  notes = "DYNADASHBOARD-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-DYNADASHBOARD-searchDefault-all','DemoSys-DYNADASHBOARD-Get-all') or hasPermission(#dto,'DemoSys-DYNADASHBOARD-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "dynadashboards/fetchdefault")
    public ResponseEntity<List<DYNADASHBOARDDTO>> fetchDefault
            (DYNADASHBOARDSearchContext dto) {
        Page<DYNADASHBOARD> domains = dynadashboardService.searchDefault(dto) ;
        List<DYNADASHBOARDDTO> list = dynadashboarddtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-DYNADASHBOARD-Create-all')")
    @ApiOperation(value = "批量新建动态数据看板", tags = {"动态数据看板" },  notes = "批量新建动态数据看板")
	@RequestMapping(method = RequestMethod.POST, value = "dynadashboards/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<DYNADASHBOARDDTO> dtos) {
        dynadashboardService.createBatch(dynadashboarddtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-DYNADASHBOARD-Update-all')")
    @ApiOperation(value = "批量更新动态数据看板", tags = {"动态数据看板" },  notes = "批量更新动态数据看板")
	@RequestMapping(method = RequestMethod.PUT, value = "dynadashboards/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<DYNADASHBOARDDTO> dtos) {
        dynadashboardService.updateBatch(dynadashboarddtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-DYNADASHBOARD-Save-all')")
    @ApiOperation(value = "批量保存动态数据看板", tags = {"动态数据看板" },  notes = "批量保存动态数据看板")
	@RequestMapping(method = RequestMethod.POST, value = "dynadashboards/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<DYNADASHBOARDDTO> dtos) {
        dynadashboardService.saveBatch(dynadashboarddtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-DYNADASHBOARD-Save-all')")
    @ApiOperation(value = "批量导入动态数据看板", tags = {"动态数据看板" },  notes = "批量导入动态数据看板")
	@RequestMapping(method = RequestMethod.POST, value = "dynadashboards/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<DYNADASHBOARDDTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<DYNADASHBOARD> list=dynadashboarddtoMapping.toDomain(dtos);
            List<DYNADASHBOARD> rtList=new ArrayList();
            list.forEach(item->{
                if(dynadashboardService.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-DYNADASHBOARD-Remove-all')")
    @ApiOperation(value = "批量删除动态数据看板", tags = {"动态数据看板" },  notes = "批量删除动态数据看板")
	@RequestMapping(method = RequestMethod.DELETE, value = {"dynadashboards","/dynadashboards/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        dynadashboardService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
