package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZOrderDetailDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("订单明细")
public class IBIZOrderDetailDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 小计
     */
    @JsonProperty("amount")
    @JSONField(name = "amount")
    @ApiModelProperty("小计")
    private BigDecimal amount;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 测试属性
     */
    @JsonProperty("ibizorderdetaila")
    @JSONField(name = "ibizorderdetaila")
    @ApiModelProperty("测试属性")
    private String ibizorderdetaila;

    /**
     * 订单明细标识
     */
    @JsonProperty("ibizorderdetailid")
    @JSONField(name = "ibizorderdetailid")
    @ApiModelProperty("订单明细标识")
    private String ibizOrderDetailId;

    /**
     * 订单明细名称
     */
    @JsonProperty("ibizorderdetailname")
    @JSONField(name = "ibizorderdetailname")
    @ApiModelProperty("订单明细名称")
    private String ibizOrderDetailName;

    /**
     * 订单标识
     */
    @JsonProperty("ibizorderid")
    @JSONField(name = "ibizorderid")
    @ApiModelProperty("订单标识")
    private String ibizOrderId;

    /**
     * 订单名称
     */
    @JsonProperty("ibizordername")
    @JSONField(name = "ibizordername")
    @ApiModelProperty("订单名称")
    private String ibizOrderName;

    /**
     * 统一产品标识
     */
    @JsonProperty("ibizuniproductid")
    @JSONField(name = "ibizuniproductid")
    @ApiModelProperty("统一产品标识")
    private String ibizuniProductId;

    /**
     * 产品名称
     */
    @JsonProperty("ibizuniproductname")
    @JSONField(name = "ibizuniproductname")
    @ApiModelProperty("产品名称")
    private String ibizuniProductName;

    /**
     * 订单编号
     */
    @JsonProperty("orderuid")
    @JSONField(name = "orderuid")
    @ApiModelProperty("订单编号")
    private String orderUid;

    /**
     * 数量
     */
    @JsonProperty("quantity")
    @JSONField(name = "quantity")
    @ApiModelProperty("数量")
    private Integer quantity;

    /**
     * 单位
     */
    @JsonProperty("unit")
    @JSONField(name = "unit")
    @ApiModelProperty("单位")
    private String unit;

    /**
     * 单价
     */
    @JsonProperty("unitprice")
    @JSONField(name = "unitprice")
    @ApiModelProperty("单价")
    private BigDecimal unitPrice;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [小计]
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [测试属性]
     */
    public void setIbizorderdetaila(String ibizorderdetaila) {
        this.ibizorderdetaila = ibizorderdetaila;
        this.modify("ibizorderdetaila", ibizorderdetaila);
    }

    /**
     * 设置 [订单明细名称]
     */
    public void setIbizOrderDetailName(String ibizOrderDetailName) {
        this.ibizOrderDetailName = ibizOrderDetailName;
        this.modify("ibizorderdetailname", ibizOrderDetailName);
    }

    /**
     * 设置 [订单标识]
     */
    public void setIbizOrderId(String ibizOrderId) {
        this.ibizOrderId = ibizOrderId;
        this.modify("ibizorderid", ibizOrderId);
    }

    /**
     * 设置 [订单名称]
     */
    public void setIbizOrderName(String ibizOrderName) {
        this.ibizOrderName = ibizOrderName;
        this.modify("ibizordername", ibizOrderName);
    }

    /**
     * 设置 [统一产品标识]
     */
    public void setIbizuniProductId(String ibizuniProductId) {
        this.ibizuniProductId = ibizuniProductId;
        this.modify("ibizuniproductid", ibizuniProductId);
    }

    /**
     * 设置 [产品名称]
     */
    public void setIbizuniProductName(String ibizuniProductName) {
        this.ibizuniProductName = ibizuniProductName;
        this.modify("ibizuniproductname", ibizuniProductName);
    }

    /**
     * 设置 [订单编号]
     */
    public void setOrderUid(String orderUid) {
        this.orderUid = orderUid;
        this.modify("orderuid", orderUid);
    }

    /**
     * 设置 [数量]
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
        this.modify("quantity", quantity);
    }

    /**
     * 设置 [单位]
     */
    public void setUnit(String unit) {
        this.unit = unit;
        this.modify("unit", unit);
    }

    /**
     * 设置 [单价]
     */
    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        this.modify("unitprice", unitPrice);
    }


}
