package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZCustomerDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("客户")
public class IBIZCustomerDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 公司地址
     */
    @JsonProperty("address")
    @JSONField(name = "address")
    @ApiModelProperty("公司地址")
    private String address;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 客户编号
     */
    @JsonProperty("customeruid")
    @JSONField(name = "customeruid")
    @ApiModelProperty("客户编号")
    private String customerUid;

    /**
     * 客户标识
     */
    @JsonProperty("ibizcustomerid")
    @JSONField(name = "ibizcustomerid")
    @ApiModelProperty("客户标识")
    private String ibizCustomerId;

    /**
     * 客户名称
     */
    @JsonProperty("ibizcustomername")
    @JSONField(name = "ibizcustomername")
    @ApiModelProperty("客户名称")
    private String ibizCustomerName;

    /**
     * 客户编号
     */
    @JsonProperty("sn")
    @JSONField(name = "sn")
    @ApiModelProperty("客户编号")
    private String sn;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [公司地址]
     */
    public void setAddress(String address) {
        this.address = address;
        this.modify("address", address);
    }

    /**
     * 设置 [客户编号]
     */
    public void setCustomerUid(String customerUid) {
        this.customerUid = customerUid;
        this.modify("customeruid", customerUid);
    }

    /**
     * 设置 [客户名称]
     */
    public void setIbizCustomerName(String ibizCustomerName) {
        this.ibizCustomerName = ibizCustomerName;
        this.modify("ibizcustomername", ibizCustomerName);
    }

    /**
     * 设置 [客户编号]
     */
    public void setSn(String sn) {
        this.sn = sn;
        this.modify("sn", sn);
    }


}
