package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZAPPEDITORDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("编辑器")
public class IBIZAPPEDITORDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 数量
     */
    @JsonProperty("amount")
    @JSONField(name = "amount")
    @ApiModelProperty("数量")
    private Integer amount;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 文档地址
     */
    @JsonProperty("documentaddress")
    @JSONField(name = "documentaddress")
    @ApiModelProperty("文档地址")
    private String documentaddress;

    /**
     * 编辑器标识
     */
    @JsonProperty("ibizappeditorid")
    @JSONField(name = "ibizappeditorid")
    @ApiModelProperty("编辑器标识")
    private String ibizappeditorid;

    /**
     * 编辑器名称
     */
    @JsonProperty("ibizappeditorname")
    @JSONField(name = "ibizappeditorname")
    @ApiModelProperty("编辑器名称")
    private String ibizappeditorName;

    /**
     * 编辑器类型
     */
    @JsonProperty("ibizappeditortype")
    @JSONField(name = "ibizappeditortype")
    @ApiModelProperty("编辑器类型")
    private String ibizappeditortype;

    /**
     * 编辑器描述
     */
    @JsonProperty("rditordescription")
    @JSONField(name = "rditordescription")
    @ApiModelProperty("编辑器描述")
    private String rditordescription;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [数量]
     */
    public void setAmount(Integer amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [文档地址]
     */
    public void setDocumentaddress(String documentaddress) {
        this.documentaddress = documentaddress;
        this.modify("documentaddress", documentaddress);
    }

    /**
     * 设置 [编辑器名称]
     */
    public void setIbizappeditorName(String ibizappeditorName) {
        this.ibizappeditorName = ibizappeditorName;
        this.modify("ibizappeditorname", ibizappeditorName);
    }

    /**
     * 设置 [编辑器类型]
     */
    public void setIbizappeditortype(String ibizappeditortype) {
        this.ibizappeditortype = ibizappeditortype;
        this.modify("ibizappeditortype", ibizappeditortype);
    }

    /**
     * 设置 [编辑器描述]
     */
    public void setRditordescription(String rditordescription) {
        this.rditordescription = rditordescription;
        this.modify("rditordescription", rditordescription);
    }


}
