package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0003;
import cn.ibizlab.core.sample.filter.IBIZSample0003SearchContext;
import cn.ibizlab.core.sample.service.IBIZSample0003Service;
import cn.ibizlab.core.sample.mapper.IBIZSample0003Mapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;


/**
 * 实体[示例实体03] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0003Service")
public class IBIZSample0003ServiceBase extends ServiceImpl<IBIZSample0003Mapper,IBIZSample0003> implements IBIZSample0003Service {


    protected int batchSize = 500;

    public IBIZSample0003 get(IBIZSample0003 et) {
        IBIZSample0003 rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,示例实体03:"+et.getIbizsample0003Id());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZSample0003> getByEntities(List<IBIZSample0003> entities) {
        return this.baseMapper.selectEntities(entities);
    }

    public void fillParentData(IBIZSample0003 et) {
        if(!ObjectUtils.isEmpty(et.getPibizsample0003id())) {
            IBIZSample0003 ibizSample0003 = et.getPibizsample0003();
            if(!ObjectUtils.isEmpty(ibizSample0003)) {
                et.setPibizsample0003Name(ibizSample0003.getIbizsample0003Name());   
            }
        }    
    }

    public IBIZSample0003 getDraft(IBIZSample0003 et) {
        fillParentData(et);
        return et;
    }

    public Integer checkKey(IBIZSample0003 et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizsample0003Id())) && this.count(Wrappers.<IBIZSample0003>query().eq("ibizsample0003id", et.getIbizsample0003Id()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZSample0003 et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZSample0003> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZSample0003 et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizsample0003id", et.getIbizsample0003Id());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZSample0003> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZSample0003 et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZSample0003> list) {
        List<IBIZSample0003> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizsample0003Id();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZSample0003> _create=new ArrayList<>();
        List<IBIZSample0003> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizsample0003Id();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZSample0003 et) {
        String key = et.getIbizsample0003Id();

        if(!remove(new QueryWrapper<IBIZSample0003>()
                .eq("ibizsample0003id", et.getIbizsample0003Id())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZSample0003> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZSample0003> searchCurData(IBIZSample0003SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0003> pages=baseMapper.searchCurData(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0003>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample0003> listCurData(IBIZSample0003SearchContext context) {
        return baseMapper.listCurData(context,context.getSelectCond());
    }

    public Page<IBIZSample0003> searchDefault(IBIZSample0003SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0003> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0003>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample0003> listDefault(IBIZSample0003SearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }

    public Page<IBIZSample0003> searchTopData(IBIZSample0003SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0003> pages=baseMapper.searchTopData(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0003>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample0003> listTopData(IBIZSample0003SearchContext context) {
        return baseMapper.listTopData(context,context.getSelectCond());
    }

    public List<IBIZSample0003> selectByPibizsample0003id(String pibizsample0003id) {
        return baseMapper.selectByPibizsample0003id(pibizsample0003id);
    }

    public boolean removeByPibizsample0003id(String pibizsample0003id) {
        return this.remove(new QueryWrapper<IBIZSample0003>().eq("pibizsample0003id",pibizsample0003id));
    }

    public boolean resetByPibizsample0003id(String pibizsample0003id) {
        return this.update(new UpdateWrapper<IBIZSample0003>().set("pibizsample0003id",null).eq("pibizsample0003id",pibizsample0003id));
    }

    public boolean saveByPibizsample0003(IBIZSample0003 ibizSample0003,List<IBIZSample0003> list) {
        if(list==null)
            return true;
        Set<String> delIds=new HashSet<String>();
        List<IBIZSample0003> _update=new ArrayList<IBIZSample0003>();
        List<IBIZSample0003> _create=new ArrayList<IBIZSample0003>();
        for(IBIZSample0003 before:selectByPibizsample0003id(ibizSample0003.getIbizsample0003Id())){
            delIds.add(before.getIbizsample0003Id());
        }
        for(IBIZSample0003 sub:list) {
            sub.setPibizsample0003id(ibizSample0003.getIbizsample0003Id());
            sub.setPibizsample0003(ibizSample0003);
            if(ObjectUtils.isEmpty(sub.getIbizsample0003Id()))
                sub.setIbizsample0003Id((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getIbizsample0003Id())) {
                delIds.remove(sub.getIbizsample0003Id());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        if(delIds.size()>0 && (!getSelf().removeBatch(delIds)))
            return false;
        return true;
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

}