package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZStorage;
import cn.ibizlab.core.sample.filter.IBIZStorageSearchContext;
import cn.ibizlab.core.sample.domain.IBIZHardware;

public interface IBIZStorageService extends IService<IBIZStorage> {

    default IBIZStorageService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZStorage get(IBIZStorage et);
    default IBIZStorage get(String key) {
        IBIZStorage et = new IBIZStorage();
        et.setIbizStorageId(key);
        return getSelf().get(et);
    }
    default List<IBIZStorage> getByIds(Collection<String> ids) {
        List<IBIZStorage> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZStorage et = new IBIZStorage();
            et.setIbizStorageId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZStorage> getByEntities(List<IBIZStorage> entities);

    IBIZStorage getDraft(IBIZStorage et);

    Integer checkKey(IBIZStorage et);

    boolean create(IBIZStorage et);
    boolean createBatch(List<IBIZStorage> list);

    boolean update(IBIZStorage et);
    boolean updateBatch(List<IBIZStorage> list);

    boolean save(IBIZStorage et);
    boolean saveBatch(List<IBIZStorage> list);

    default boolean remove(String key) {
        IBIZStorage et = new IBIZStorage();
        et.setIbizStorageId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZStorage et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZStorage> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZStorage et = new IBIZStorage();
            et.setIbizStorageId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZStorage> entities);

    Page<IBIZStorage> searchDefault(IBIZStorageSearchContext context);
    List<IBIZStorage> listDefault(IBIZStorageSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}