package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0009;
import cn.ibizlab.core.sample.filter.IBIZSample0009SearchContext;

public interface IBIZSample0009Service extends IService<IBIZSample0009> {

    default IBIZSample0009Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0009 get(IBIZSample0009 et);
    default IBIZSample0009 get(String key) {
        IBIZSample0009 et = new IBIZSample0009();
        et.setIbizSample0009Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0009> getByIds(Collection<String> ids) {
        List<IBIZSample0009> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0009 et = new IBIZSample0009();
            et.setIbizSample0009Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0009> getByEntities(List<IBIZSample0009> entities);

    IBIZSample0009 getDraft(IBIZSample0009 et);

    Integer checkKey(IBIZSample0009 et);

    boolean create(IBIZSample0009 et);
    boolean createBatch(List<IBIZSample0009> list);

    boolean update(IBIZSample0009 et);
    boolean updateBatch(List<IBIZSample0009> list);

    boolean save(IBIZSample0009 et);
    boolean saveBatch(List<IBIZSample0009> list);

    default boolean remove(String key) {
        IBIZSample0009 et = new IBIZSample0009();
        et.setIbizSample0009Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0009 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0009> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0009 et = new IBIZSample0009();
            et.setIbizSample0009Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0009> entities);

    Page<IBIZSample0009> searchDefault(IBIZSample0009SearchContext context);
    List<IBIZSample0009> listDefault(IBIZSample0009SearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}