package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0007;
import cn.ibizlab.core.sample.filter.IBIZSample0007SearchContext;
import cn.ibizlab.core.sample.domain.IBIZSample0006;

public interface IBIZSample0007Service extends IService<IBIZSample0007> {

    default IBIZSample0007Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0007 get(IBIZSample0007 et);
    default IBIZSample0007 get(String key) {
        IBIZSample0007 et = new IBIZSample0007();
        et.setIbizSample0007Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0007> getByIds(Collection<String> ids) {
        List<IBIZSample0007> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0007 et = new IBIZSample0007();
            et.setIbizSample0007Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0007> getByEntities(List<IBIZSample0007> entities);

    IBIZSample0007 getDraft(IBIZSample0007 et);

    Integer checkKey(IBIZSample0007 et);

    boolean create(IBIZSample0007 et);
    boolean createBatch(List<IBIZSample0007> list);

    boolean update(IBIZSample0007 et);
    boolean updateBatch(List<IBIZSample0007> list);

    boolean save(IBIZSample0007 et);
    boolean saveBatch(List<IBIZSample0007> list);

    default boolean remove(String key) {
        IBIZSample0007 et = new IBIZSample0007();
        et.setIbizSample0007Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0007 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0007> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0007 et = new IBIZSample0007();
            et.setIbizSample0007Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0007> entities);

    Page<IBIZSample0007> searchCurGw(IBIZSample0007SearchContext context);
    List<IBIZSample0007> listCurGw(IBIZSample0007SearchContext context);

    Page<IBIZSample0007> searchDefault(IBIZSample0007SearchContext context);
    List<IBIZSample0007> listDefault(IBIZSample0007SearchContext context);

    List<IBIZSample0007> selectByIbizSample0006Id(String ibizSample0006Id);
    boolean removeByIbizSample0006Id(String ibizSample0006Id);
    boolean resetByIbizSample0006Id(String ibizSample0006Id);
    boolean saveByIbizsample0006(cn.ibizlab.core.sample.domain.IBIZSample0006 ibizSample0006,List<IBIZSample0007> list);
    default boolean saveByIbizSample0006Id(String ibizSample0006Id,List<IBIZSample0007> list) {
        cn.ibizlab.core.sample.domain.IBIZSample0006 et = new cn.ibizlab.core.sample.domain.IBIZSample0006();
        et.setIbizSample0006Id(ibizSample0006Id);
        return getSelf().saveByIbizsample0006(et,list);
    }


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}