package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZQJ;
import cn.ibizlab.core.sample.filter.IBIZQJSearchContext;

public interface IBIZQJService extends IService<IBIZQJ> {

    default IBIZQJService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZQJ get(IBIZQJ et);
    default IBIZQJ get(String key) {
        IBIZQJ et = new IBIZQJ();
        et.setIbizqjid(key);
        return getSelf().get(et);
    }
    default List<IBIZQJ> getByIds(Collection<String> ids) {
        List<IBIZQJ> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZQJ et = new IBIZQJ();
            et.setIbizqjid(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZQJ> getByEntities(List<IBIZQJ> entities);

    IBIZQJ getDraft(IBIZQJ et);

    Integer checkKey(IBIZQJ et);

    boolean create(IBIZQJ et);
    boolean createBatch(List<IBIZQJ> list);

    boolean update(IBIZQJ et);
    boolean updateBatch(List<IBIZQJ> list);

    boolean save(IBIZQJ et);
    boolean saveBatch(List<IBIZQJ> list);

    default boolean remove(String key) {
        IBIZQJ et = new IBIZQJ();
        et.setIbizqjid(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZQJ et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZQJ> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZQJ et = new IBIZQJ();
            et.setIbizqjid(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZQJ> entities);

    Page<IBIZQJ> searchDefault(IBIZQJSearchContext context);
    List<IBIZQJ> listDefault(IBIZQJSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}