package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZCustomerMG;
import cn.ibizlab.core.sample.filter.IBIZCustomerMGSearchContext;
import cn.ibizlab.core.sample.domain.IBIZCustomer;

public interface IBIZCustomerMGService extends IService<IBIZCustomerMG> {

    default IBIZCustomerMGService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZCustomerMG get(IBIZCustomerMG et);
    default IBIZCustomerMG get(String key) {
        IBIZCustomerMG et = new IBIZCustomerMG();
        et.setIbizCustomerId(key);
        return getSelf().get(et);
    }
    default List<IBIZCustomerMG> getByIds(Collection<String> ids) {
        List<IBIZCustomerMG> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZCustomerMG et = new IBIZCustomerMG();
            et.setIbizCustomerId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZCustomerMG> getByEntities(List<IBIZCustomerMG> entities);

    IBIZCustomerMG getDraft(IBIZCustomerMG et);

    Integer checkKey(IBIZCustomerMG et);

    boolean create(IBIZCustomerMG et);
    boolean createBatch(List<IBIZCustomerMG> list);

    boolean update(IBIZCustomerMG et);
    boolean updateBatch(List<IBIZCustomerMG> list);

    boolean save(IBIZCustomerMG et);
    boolean saveBatch(List<IBIZCustomerMG> list);

    default boolean remove(String key) {
        IBIZCustomerMG et = new IBIZCustomerMG();
        et.setIbizCustomerId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZCustomerMG et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZCustomerMG> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZCustomerMG et = new IBIZCustomerMG();
            et.setIbizCustomerId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZCustomerMG> entities);

    Page<IBIZCustomerMG> searchDefault(IBIZCustomerMGSearchContext context);
    List<IBIZCustomerMG> listDefault(IBIZCustomerMGSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}