package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZAccount;
import cn.ibizlab.core.sample.filter.IBIZAccountSearchContext;
import cn.ibizlab.core.sample.domain.IBIZCustomer;

public interface IBIZAccountService extends IService<IBIZAccount> {

    default IBIZAccountService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZAccount get(IBIZAccount et);
    default IBIZAccount get(String key) {
        IBIZAccount et = new IBIZAccount();
        et.setIbizAccountId(key);
        return getSelf().get(et);
    }
    default List<IBIZAccount> getByIds(Collection<String> ids) {
        List<IBIZAccount> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZAccount et = new IBIZAccount();
            et.setIbizAccountId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZAccount> getByEntities(List<IBIZAccount> entities);

    IBIZAccount getDraft(IBIZAccount et);

    Integer checkKey(IBIZAccount et);

    boolean create(IBIZAccount et);
    boolean createBatch(List<IBIZAccount> list);

    boolean update(IBIZAccount et);
    boolean updateBatch(List<IBIZAccount> list);

    boolean save(IBIZAccount et);
    boolean saveBatch(List<IBIZAccount> list);

    default boolean remove(String key) {
        IBIZAccount et = new IBIZAccount();
        et.setIbizAccountId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZAccount et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZAccount> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZAccount et = new IBIZAccount();
            et.setIbizAccountId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZAccount> entities);

    Page<IBIZAccount> searchDefault(IBIZAccountSearchContext context);
    List<IBIZAccount> listDefault(IBIZAccountSearchContext context);

    List<IBIZAccount> selectByIbizAccountId(String ibizAccountId);
    boolean removeByIbizAccountId(String ibizAccountId);
    boolean resetByIbizAccountId(String ibizAccountId);
    boolean saveByIbizcustomer(cn.ibizlab.core.sample.domain.IBIZCustomer ibizCustomer,List<IBIZAccount> list);
    default boolean saveByIbizAccountId(String ibizAccountId,List<IBIZAccount> list) {
        cn.ibizlab.core.sample.domain.IBIZCustomer et = new cn.ibizlab.core.sample.domain.IBIZCustomer();
        et.setIbizCustomerId(ibizAccountId);
        return getSelf().saveByIbizcustomer(et,list);
    }


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}