package cn.ibizlab.core.sample.mapping;

import org.mapstruct.*;
import cn.ibizlab.core.sample.domain.IBIZHardware;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
import java.util.List;

@Mapper(componentModel = "spring", uses = {})
public interface IBIZHardwareInheritMapping {

    @Mappings({
            @Mapping(target ="focusNull",ignore = true),
            @Mapping(source ="ibizHardwareId",target = "ibizuniProductId"),
            @Mapping(source ="ibizHardwareName",target = "ibizuniProductName"),
    })
    IBIZUNIProduct toIbizuniProduct(IBIZHardware ibizHardware);

    @Mappings({
            @Mapping(target ="focusNull",ignore = true),
            @Mapping(source ="ibizuniProductId",target = "ibizHardwareId"),
            @Mapping(source ="ibizuniProductName",target = "ibizHardwareName"),
    })
    IBIZHardware toIbizHardware(IBIZUNIProduct ibizuniProduct);

    List<IBIZUNIProduct> toIbizuniProduct(List<IBIZHardware> list);

    List<IBIZHardware> toIbizHardware(List<IBIZUNIProduct> list);

}
