package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZViewMsg;
/**
 * 关系型数据实体[IBIZViewMsg] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("视图消息源")
public class IBIZViewMsgSearchContext extends QueryWrapperContext<IBIZViewMsg> {

    @JsonProperty("n_ibizviewmsgid_eq")
    @JSONField(name = "n_ibizviewmsgid_eq")
    @ApiModelProperty("视图消息源标识EQ")
	private String ibizViewMsgIdEQ;
	public IBIZViewMsgSearchContext setIbizViewMsgIdEQ(String ibizViewMsgIdEQ) {
        this.ibizViewMsgIdEQ = ibizViewMsgIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizViewMsgIdEQ)){
            this.getSearchCond().eq("ibizviewmsgid", ibizViewMsgIdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizviewmsgname_like")
    @JSONField(name = "n_ibizviewmsgname_like")
    @ApiModelProperty("视图消息源名称LIKE")
	private String ibizViewMsgNameLIKE;
	public IBIZViewMsgSearchContext setIbizViewMsgNameLIKE(String ibizViewMsgNameLIKE) {
        this.ibizViewMsgNameLIKE = ibizViewMsgNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizViewMsgNameLIKE)){
            this.getSearchCond().like("ibizviewmsgname", ibizViewMsgNameLIKE);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizviewmsgname", query)
            );
		}
	}
}