package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
/**
 * 关系型数据实体[IBIZUNIProduct] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("统一产品（索引主实体）")
public class IBIZUNIProductSearchContext extends QueryWrapperContext<IBIZUNIProduct> {

    @JsonProperty("n_ibizuniproductname_like")
    @JSONField(name = "n_ibizuniproductname_like")
    @ApiModelProperty("产品名称LIKE")
	private String ibizuniProductNameLIKE;
	public IBIZUNIProductSearchContext setIbizuniProductNameLIKE(String ibizuniProductNameLIKE) {
        this.ibizuniProductNameLIKE = ibizuniProductNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizuniProductNameLIKE)){
            this.getSearchCond().like("ibizuniproductname", ibizuniProductNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizuniproducttype_eq")
    @JSONField(name = "n_ibizuniproducttype_eq")
    @ApiModelProperty("分组类型EQ")
	private String ibizuniProductTypeEQ;
	public IBIZUNIProductSearchContext setIbizuniProductTypeEQ(String ibizuniProductTypeEQ) {
        this.ibizuniProductTypeEQ = ibizuniProductTypeEQ;
        if(!ObjectUtils.isEmpty(this.ibizuniProductTypeEQ)){
            this.getSearchCond().eq("ibizuniproducttype", ibizuniProductTypeEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizuniproductid_eq")
    @JSONField(name = "n_ibizuniproductid_eq")
    @ApiModelProperty("统一产品标识EQ")
	private String ibizuniProductIdEQ;
	public IBIZUNIProductSearchContext setIbizuniProductIdEQ(String ibizuniProductIdEQ) {
        this.ibizuniProductIdEQ = ibizuniProductIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizuniProductIdEQ)){
            this.getSearchCond().eq("ibizuniproductid", ibizuniProductIdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizuniproductname", query)
            );
		}
	}
}