package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSupplier;
/**
 * 关系型数据实体[IBIZSupplier] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("供货商")
public class IBIZSupplierSearchContext extends QueryWrapperContext<IBIZSupplier> {

    @JsonProperty("n_suppliername_like")
    @JSONField(name = "n_suppliername_like")
    @ApiModelProperty("供应商名称LIKE")
	private String supplierNameLIKE;
	public IBIZSupplierSearchContext setSupplierNameLIKE(String supplierNameLIKE) {
        this.supplierNameLIKE = supplierNameLIKE;
        if(!ObjectUtils.isEmpty(this.supplierNameLIKE)){
            this.getSearchCond().like("suppliername", supplierNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_supplierid_eq")
    @JSONField(name = "n_supplierid_eq")
    @ApiModelProperty("供应商标识EQ")
	private String supplierIdEQ;
	public IBIZSupplierSearchContext setSupplierIdEQ(String supplierIdEQ) {
        this.supplierIdEQ = supplierIdEQ;
        if(!ObjectUtils.isEmpty(this.supplierIdEQ)){
            this.getSearchCond().eq("supplierid", supplierIdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("suppliername", query)
            );
		}
	}
}