package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSoftwareSuit;
/**
 * 关系型数据实体[IBIZSoftwareSuit] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("软件")
public class IBIZSoftwareSuitSearchContext extends QueryWrapperContext<IBIZSoftwareSuit> {

    @JsonProperty("n_ibizsoftwaresuitid_eq")
    @JSONField(name = "n_ibizsoftwaresuitid_eq")
    @ApiModelProperty("软件标识EQ")
	private String ibizSoftwareSuitIdEQ;
	public IBIZSoftwareSuitSearchContext setIbizSoftwareSuitIdEQ(String ibizSoftwareSuitIdEQ) {
        this.ibizSoftwareSuitIdEQ = ibizSoftwareSuitIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSoftwareSuitIdEQ)){
            this.getSearchCond().eq("ibizsoftwaresuitid", ibizSoftwareSuitIdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsoftwaresuitname_like")
    @JSONField(name = "n_ibizsoftwaresuitname_like")
    @ApiModelProperty("软件名称LIKE")
	private String ibizSoftwareSuitNameLIKE;
	public IBIZSoftwareSuitSearchContext setIbizSoftwareSuitNameLIKE(String ibizSoftwareSuitNameLIKE) {
        this.ibizSoftwareSuitNameLIKE = ibizSoftwareSuitNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSoftwareSuitNameLIKE)){
            this.getSearchCond().like("ibizsoftwaresuitname", ibizSoftwareSuitNameLIKE);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsoftwaresuitname", query)
            );
		}
	}
}