package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0005;
/**
 * 关系型数据实体[IBIZSample0005] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("多模式流程")
public class IBIZSample0005SearchContext extends QueryWrapperContext<IBIZSample0005> {

    @JsonProperty("n_ibizsample0005id_eq")
    @JSONField(name = "n_ibizsample0005id_eq")
    @ApiModelProperty("多模式流程标识EQ")
	private String ibizSample0005IdEQ;
	public IBIZSample0005SearchContext setIbizSample0005IdEQ(String ibizSample0005IdEQ) {
        this.ibizSample0005IdEQ = ibizSample0005IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0005IdEQ)){
            this.getSearchCond().eq("ibizsample0005id", ibizSample0005IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_wfmmstep_eq")
    @JSONField(name = "n_wfmmstep_eq")
    @ApiModelProperty("工作流步骤EQ")
	private String wfmmStepEQ;
	public IBIZSample0005SearchContext setWfmmStepEQ(String wfmmStepEQ) {
        this.wfmmStepEQ = wfmmStepEQ;
        if(!ObjectUtils.isEmpty(this.wfmmStepEQ)){
            this.getSearchCond().eq("wfmmstep", wfmmStepEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_wfmmtype_eq")
    @JSONField(name = "n_wfmmtype_eq")
    @ApiModelProperty("订单类型EQ")
	private String wfmmTypeEQ;
	public IBIZSample0005SearchContext setWfmmTypeEQ(String wfmmTypeEQ) {
        this.wfmmTypeEQ = wfmmTypeEQ;
        if(!ObjectUtils.isEmpty(this.wfmmTypeEQ)){
            this.getSearchCond().eq("wfmmtype", wfmmTypeEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0005name_like")
    @JSONField(name = "n_ibizsample0005name_like")
    @ApiModelProperty("多模式流程名称LIKE")
	private String ibizSample0005NameLIKE;
	public IBIZSample0005SearchContext setIbizSample0005NameLIKE(String ibizSample0005NameLIKE) {
        this.ibizSample0005NameLIKE = ibizSample0005NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0005NameLIKE)){
            this.getSearchCond().like("ibizsample0005name", ibizSample0005NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_wfmmstate_eq")
    @JSONField(name = "n_wfmmstate_eq")
    @ApiModelProperty("状态EQ")
	private String wfmmStateEQ;
	public IBIZSample0005SearchContext setWfmmStateEQ(String wfmmStateEQ) {
        this.wfmmStateEQ = wfmmStateEQ;
        if(!ObjectUtils.isEmpty(this.wfmmStateEQ)){
            this.getSearchCond().eq("wfmmstate", wfmmStateEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0005name", query)
            );
		}
	}
}