package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import cn.ibizlab.core.sample.domain.IBIZTASK;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZTASKTEAM", resultMap = "IBIZTASKTEAMResultMap")
@ApiModel(value = "IBIZTASKTEAM", description = "任务团队")
public class IBIZTASKTEAM extends EntityMP implements Serializable
{

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 任务团队名称
     */
    @TableField(value = "ibiztaskteamname")
    @DEField(name = "ibiztaskteamname")
    @JsonProperty("ibiztaskteamname")
    @JSONField(name = "ibiztaskteamname")
    @ApiModelProperty(value = "ibiztaskteamname", notes = "任务团队名称")
    private String ibiztaskteamName;

    /**
     * 任务团队标识
     */
    @Id
    @TableId(value = "ibiztaskteamid" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibiztaskteamid" , isKeyField = true)
    @JsonProperty("ibiztaskteamid")
    @JSONField(name = "ibiztaskteamid")
    @ApiModelProperty(value = "ibiztaskteamid", notes = "任务团队标识")
    private String ibiztaskteamid;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 任务标识
     */
    @TableField(value = "root")
    @DEField(name = "root")
    @JsonProperty("root")
    @JSONField(name = "root")
    @ApiModelProperty(value = "root", notes = "任务标识")
    private String root;

    /**
     * 用户
     */
    @TableField(value = "account")
    @DEField(name = "account")
    @JsonProperty("account")
    @JSONField(name = "account")
    @ApiModelProperty(value = "account", notes = "用户")
    private String account;

    /**
     * 角色
     */
    @TableField(value = "role")
    @DEField(name = "role")
    @JsonProperty("role")
    @JSONField(name = "role")
    @ApiModelProperty(value = "role", notes = "角色")
    private String role;


    /**
     * 任务
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    @ApiModelProperty(value = "taskteam", notes = "")
    private IBIZTASK taskTeam;




    /**
     * 设置 [任务团队名称]
     */
    public void setIbiztaskteamName(String ibiztaskteamName) {
        this.ibiztaskteamName = ibiztaskteamName;
        this.modify("ibiztaskteamname", ibiztaskteamName);
    }




    /**
     * 设置 [任务标识]
     */
    public void setRoot(String root) {
        this.root = root;
        this.modify("root", root);
    }

    /**
     * 设置 [用户]
     */
    public void setAccount(String account) {
        this.account = account;
        this.modify("account", account);
    }

    /**
     * 设置 [角色]
     */
    public void setRole(String role) {
        this.role = role;
        this.modify("role", role);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibiztaskteamid");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}