package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0017", resultMap = "IBIZSample0017ResultMap")
@ApiModel(value = "IBIZSAMPLE0017", description = "订单")
public class IBIZSample0017 extends EntityMP implements Serializable
{

    /**
     * 订单编号
     */
    @TableField(value = "orderuid")
    @DEField(name = "orderuid" , dupCheck = DupCheck.ALL)
    @JsonProperty("orderuid")
    @JSONField(name = "orderuid")
    @ApiModelProperty(value = "orderuid", notes = "订单编号")
    private String orderUid;

    /**
     * 备注
     */
    @TableField(value = "memo")
    @DEField(name = "memo")
    @JsonProperty("memo")
    @JSONField(name = "memo")
    @ApiModelProperty(value = "memo", notes = "备注")
    private String memo;

    /**
     * 明细数
     */
    @TableField(value = "detailnum")
    @DEField(name = "detailnum")
    @JsonProperty("detailnum")
    @JSONField(name = "detailnum")
    @ApiModelProperty(value = "detailnum", notes = "明细数")
    private Integer detailNum;

    /**
     * 总计
     */
    @TableField(value = "amount")
    @DEField(name = "amount")
    @JsonProperty("amount")
    @JSONField(name = "amount")
    @ApiModelProperty(value = "amount", notes = "总计")
    private BigDecimal amount;

    /**
     * 订单时间
     */
    @TableField(value = "ordertime")
    @DEField(name = "ordertime")
    @JsonProperty("ordertime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "ordertime" , format = "yyyy-MM-dd")
    @ApiModelProperty(value = "ordertime", notes = "订单时间")
    private Timestamp orderTime;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 订单名称
     */
    @TableField(value = "ibizsample0017name")
    @DEField(name = "ibizsample0017name")
    @JsonProperty("ibizsample0017name")
    @JSONField(name = "ibizsample0017name")
    @ApiModelProperty(value = "ibizsample0017name", notes = "订单名称")
    private String ibizSample0017Name;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 订单类型
     */
    @TableField(value = "ordertype")
    @DEField(name = "ordertype" , dict = "S_OrderType")
    @JsonProperty("ordertype")
    @JSONField(name = "ordertype")
    @ApiModelProperty(value = "ordertype", notes = "订单类型")
    private String orderType;

    /**
     * 订单标识
     */
    @Id
    @TableId(value = "ibizsample0017id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0017id" , isKeyField = true)
    @JsonProperty("ibizsample0017id")
    @JSONField(name = "ibizsample0017id")
    @ApiModelProperty(value = "ibizsample0017id", notes = "订单标识")
    private String ibizSample0017Id;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;




    /**
     * 设置 [订单编号]
     */
    public void setOrderUid(String orderUid) {
        this.orderUid = orderUid;
        this.modify("orderuid", orderUid);
    }

    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [明细数]
     */
    public void setDetailNum(Integer detailNum) {
        this.detailNum = detailNum;
        this.modify("detailnum", detailNum);
    }

    /**
     * 设置 [总计]
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [订单时间]
     */
    public void setOrderTime(Timestamp orderTime) {
        this.orderTime = orderTime;
        this.modify("ordertime", orderTime);
    }


    /**
     * 设置 [订单名称]
     */
    public void setIbizSample0017Name(String ibizSample0017Name) {
        this.ibizSample0017Name = ibizSample0017Name;
        this.modify("ibizsample0017name", ibizSample0017Name);
    }



    /**
     * 设置 [订单类型]
     */
    public void setOrderType(String orderType) {
        this.orderType = orderType;
        this.modify("ordertype", orderType);
    }





    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0017id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}