package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0004", resultMap = "IBIZSample0004ResultMap")
@ApiModel(value = "IBIZSAMPLE0004", description = "多版本流程")
public class IBIZSample0004 extends EntityMP implements Serializable
{

    /**
     * 备注
     */
    @TableField(value = "memo")
    @DEField(name = "memo")
    @JsonProperty("memo")
    @JSONField(name = "memo")
    @ApiModelProperty(value = "memo", notes = "备注")
    private String memo;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 状态
     */
    @TableField(value = "wfmvstate")
    @DEField(name = "wfmvstate" , dict = "WFSTATE")
    @JsonProperty("wfmvstate")
    @JSONField(name = "wfmvstate")
    @ApiModelProperty(value = "wfmvstate", notes = "状态")
    private String wfmvState;

    /**
     * 订单类型
     */
    @TableField(value = "wfmvtype")
    @DEField(name = "wfmvtype" , dict = "DYNAORDERTYPE")
    @JsonProperty("wfmvtype")
    @JSONField(name = "wfmvtype")
    @ApiModelProperty(value = "wfmvtype", notes = "订单类型")
    private String wfmvtype;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 订单时间
     */
    @TableField(value = "mvdate")
    @DEField(name = "mvdate")
    @JsonProperty("mvdate")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "mvdate" , format = "yyyy-MM-dd")
    @ApiModelProperty(value = "mvdate", notes = "订单时间")
    private Timestamp mvDate;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 工作流步骤
     */
    @TableField(value = "wfmvstep")
    @DEField(name = "wfmvstep" , dict = "WFMVSTEP")
    @JsonProperty("wfmvstep")
    @JSONField(name = "wfmvstep")
    @ApiModelProperty(value = "wfmvstep", notes = "工作流步骤")
    private String wfmvStep;

    /**
     * 工作流版本
     */
    @TableField(value = "wfversion")
    @DEField(name = "wfversion")
    @JsonProperty("wfversion")
    @JSONField(name = "wfversion")
    @ApiModelProperty(value = "wfversion", notes = "工作流版本")
    private String wfVersion;

    /**
     * 工作流步骤
     */
    @TableField(value = "wfstate")
    @DEField(name = "wfstate" , dict = "WFStates")
    @JsonProperty("wfstate")
    @JSONField(name = "wfstate")
    @ApiModelProperty(value = "wfstate", notes = "工作流步骤")
    private Integer wfState;

    /**
     * 名称
     */
    @TableField(value = "ibizsample0004name")
    @DEField(name = "ibizsample0004name")
    @JsonProperty("ibizsample0004name")
    @JSONField(name = "ibizsample0004name")
    @ApiModelProperty(value = "ibizsample0004name", notes = "名称")
    private String ibizSample0004Name;

    /**
     * 工作流实例
     */
    @TableField(value = "wfinstanceid")
    @DEField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @ApiModelProperty(value = "wfinstanceid", notes = "工作流实例")
    private String wfInstanceId;

    /**
     * 多版本流程标识
     */
    @Id
    @TableId(value = "ibizsample0004id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0004id" , isKeyField = true)
    @JsonProperty("ibizsample0004id")
    @JSONField(name = "ibizsample0004id")
    @ApiModelProperty(value = "ibizsample0004id", notes = "多版本流程标识")
    private String ibizSample0004Id;

    /**
     * 订单金额
     */
    @TableField(value = "je")
    @DEField(name = "je")
    @JsonProperty("je")
    @JSONField(name = "je")
    @ApiModelProperty(value = "je", notes = "订单金额")
    private BigDecimal je;




    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }


    /**
     * 设置 [状态]
     */
    public void setWfmvState(String wfmvState) {
        this.wfmvState = wfmvState;
        this.modify("wfmvstate", wfmvState);
    }

    /**
     * 设置 [订单类型]
     */
    public void setWfmvtype(String wfmvtype) {
        this.wfmvtype = wfmvtype;
        this.modify("wfmvtype", wfmvtype);
    }



    /**
     * 设置 [订单时间]
     */
    public void setMvDate(Timestamp mvDate) {
        this.mvDate = mvDate;
        this.modify("mvdate", mvDate);
    }


    /**
     * 设置 [工作流步骤]
     */
    public void setWfmvStep(String wfmvStep) {
        this.wfmvStep = wfmvStep;
        this.modify("wfmvstep", wfmvStep);
    }

    /**
     * 设置 [工作流版本]
     */
    public void setWfVersion(String wfVersion) {
        this.wfVersion = wfVersion;
        this.modify("wfversion", wfVersion);
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfState(Integer wfState) {
        this.wfState = wfState;
        this.modify("wfstate", wfState);
    }

    /**
     * 设置 [名称]
     */
    public void setIbizSample0004Name(String ibizSample0004Name) {
        this.ibizSample0004Name = ibizSample0004Name;
        this.modify("ibizsample0004name", ibizSample0004Name);
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfInstanceId(String wfInstanceId) {
        this.wfInstanceId = wfInstanceId;
        this.modify("wfinstanceid", wfInstanceId);
    }


    /**
     * 设置 [订单金额]
     */
    public void setJe(BigDecimal je) {
        this.je = je;
        this.modify("je", je);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0004id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}