package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZCUSTOMER", resultMap = "IBIZCustomer_INTFResultMap")
@ApiModel(value = "IBIZCUSTOMER_INTF", description = "客户")
public class IBIZCustomer_INTF extends EntityMP implements Serializable
{

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 客户编号
     */
    @TableField(value = "sn")
    @DEField(name = "sn")
    @JsonProperty("sn")
    @JSONField(name = "sn")
    @ApiModelProperty(value = "sn", notes = "客户编号")
    private String sn;

    /**
     * 客户编号
     */
    @TableField(value = "customeruid")
    @DEField(name = "customeruid")
    @JsonProperty("customeruid")
    @JSONField(name = "customeruid")
    @ApiModelProperty(value = "customeruid", notes = "客户编号")
    private String customerUid;

    /**
     * ORGID
     */
    @TableField(value = "orgid")
    @DEField(name = "orgid" , preType = DEPredefinedFieldType.ORGID)
    @JsonProperty("orgid")
    @JSONField(name = "orgid")
    @ApiModelProperty(value = "orgid", notes = "ORGID")
    private String orgId;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 公司地址
     */
    @TableField(value = "address")
    @DEField(name = "address")
    @JsonProperty("address")
    @JSONField(name = "address")
    @ApiModelProperty(value = "address", notes = "公司地址")
    private String address;

    /**
     * 客户名称
     */
    @TableField(value = "ibizcustomername")
    @DEField(name = "ibizcustomername")
    @JsonProperty("ibizcustomername")
    @JSONField(name = "ibizcustomername")
    @ApiModelProperty(value = "ibizcustomername", notes = "客户名称")
    private String ibizCustomerName;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 客户标识
     */
    @Id
    @TableId(value = "ibizcustomerid" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizcustomerid" , isKeyField = true)
    @JsonProperty("ibizcustomerid")
    @JSONField(name = "ibizcustomerid")
    @ApiModelProperty(value = "ibizcustomerid", notes = "客户标识")
    private String ibizCustomerId;





    /**
     * 设置 [客户编号]
     */
    public void setSn(String sn) {
        this.sn = sn;
        this.modify("sn", sn);
    }

    /**
     * 设置 [客户编号]
     */
    public void setCustomerUid(String customerUid) {
        this.customerUid = customerUid;
        this.modify("customeruid", customerUid);
    }




    /**
     * 设置 [公司地址]
     */
    public void setAddress(String address) {
        this.address = address;
        this.modify("address", address);
    }

    /**
     * 设置 [客户名称]
     */
    public void setIbizCustomerName(String ibizCustomerName) {
        this.ibizCustomerName = ibizCustomerName;
        this.modify("ibizcustomername", ibizCustomerName);
    }





    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizcustomerid");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}