/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'ibizappeditorname',
          prop: 'ibizappeditorname',
          dataType: 'TEXT',
        },
        {
          name: 'ibizappeditortype',
          prop: 'ibizappeditortype',
          dataType: 'TEXT',
        },
        {
          name: 'rditordescription',
          prop: 'rditordescription',
          dataType: 'TEXT',
        },
        {
          name: 'documentaddress',
          prop: 'documentaddress',
          dataType: 'TEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizappeditorname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizappeditorid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizappeditorid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'ibizappeditorid',
          prop: 'ibizappeditorid',
          dataType: 'GUID',
        },
        {
          name: 'ibizappeditor',
          prop: 'ibizappeditorid',
        },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}