package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZAPPEDITORDTO]
 */
@Data
@ApiModel("编辑器")
public class IBIZAPPEDITORDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("建立人")
    private String createman;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("更新时间")
    private Timestamp updatedate;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("建立时间")
    private Timestamp createdate;

    /**
     * 属性 [IBIZAPPEDITORNAME]
     *
     */
    @JSONField(name = "ibizappeditorname")
    @JsonProperty("ibizappeditorname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("编辑器名称")
    private String ibizappeditorname;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("更新人")
    private String updateman;

    /**
     * 属性 [IBIZAPPEDITORID]
     *
     */
    @JSONField(name = "ibizappeditorid")
    @JsonProperty("ibizappeditorid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("编辑器标识")
    private String ibizappeditorid;

    /**
     * 属性 [IBIZAPPEDITORTYPE]
     *
     */
    @JSONField(name = "ibizappeditortype")
    @JsonProperty("ibizappeditortype")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("编辑器类型")
    private String ibizappeditortype;

    /**
     * 属性 [RDITORDESCRIPTION]
     *
     */
    @JSONField(name = "rditordescription")
    @JsonProperty("rditordescription")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("编辑器描述")
    private String rditordescription;

    /**
     * 属性 [DOCUMENTADDRESS]
     *
     */
    @JSONField(name = "documentaddress")
    @JsonProperty("documentaddress")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("文档地址")
    private String documentaddress;

    /**
     * 属性 [AMOUNT]
     *
     */
    @JSONField(name = "amount")
    @JsonProperty("amount")
    @ApiModelProperty("数量")
    private Integer amount;


    /**
     * 设置 [IBIZAPPEDITORNAME]
     */
    public void setIbizappeditorname(String  ibizappeditorname){
        this.ibizappeditorname = ibizappeditorname ;
        this.modify("ibizappeditorname",ibizappeditorname);
    }

    /**
     * 设置 [IBIZAPPEDITORTYPE]
     */
    public void setIbizappeditortype(String  ibizappeditortype){
        this.ibizappeditortype = ibizappeditortype ;
        this.modify("ibizappeditortype",ibizappeditortype);
    }

    /**
     * 设置 [RDITORDESCRIPTION]
     */
    public void setRditordescription(String  rditordescription){
        this.rditordescription = rditordescription ;
        this.modify("rditordescription",rditordescription);
    }

    /**
     * 设置 [DOCUMENTADDRESS]
     */
    public void setDocumentaddress(String  documentaddress){
        this.documentaddress = documentaddress ;
        this.modify("documentaddress",documentaddress);
    }

    /**
     * 设置 [AMOUNT]
     */
    public void setAmount(Integer  amount){
        this.amount = amount ;
        this.modify("amount",amount);
    }


}


