package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0013DTO]
 */
@Data
@ApiModel("订单明细")
public class IBIZSample0013DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("更新人")
    private String updateman;

    /**
     * 属性 [IBIZSAMPLE0013NAME]
     *
     */
    @JSONField(name = "ibizsample0013name")
    @JsonProperty("ibizsample0013name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("订单明细名称")
    private String ibizsample0013name;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("更新时间")
    private Timestamp updatedate;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("建立人")
    private String createman;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("建立时间")
    private Timestamp createdate;

    /**
     * 属性 [AMOUNT]
     *
     */
    @JSONField(name = "amount")
    @JsonProperty("amount")
    @ApiModelProperty("小计")
    private Double amount;

    /**
     * 属性 [QUANTITY]
     *
     */
    @JSONField(name = "quantity")
    @JsonProperty("quantity")
    @ApiModelProperty("数量")
    private Integer quantity;

    /**
     * 属性 [IBIZSAMPLE0013ID]
     *
     */
    @JSONField(name = "ibizsample0013id")
    @JsonProperty("ibizsample0013id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("订单明细标识")
    private String ibizsample0013id;

    /**
     * 属性 [UNIT]
     *
     */
    @JSONField(name = "unit")
    @JsonProperty("unit")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("单位")
    private String unit;

    /**
     * 属性 [IBIZUNIPRODUCTNAME]
     *
     */
    @JSONField(name = "ibizuniproductname")
    @JsonProperty("ibizuniproductname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("统一产品名称")
    private String ibizuniproductname;

    /**
     * 属性 [UNITPRICE]
     *
     */
    @JSONField(name = "unitprice")
    @JsonProperty("unitprice")
    @ApiModelProperty("单价")
    private Double unitprice;

    /**
     * 属性 [IBIZSAMPLE0012NAME]
     *
     */
    @JSONField(name = "ibizsample0012name")
    @JsonProperty("ibizsample0012name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("订单名称")
    private String ibizsample0012name;

    /**
     * 属性 [IBIZUNIPRODUCTID]
     *
     */
    @JSONField(name = "ibizuniproductid")
    @JsonProperty("ibizuniproductid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("统一产品标识")
    private String ibizuniproductid;

    /**
     * 属性 [IBIZSAMPLE0012ID]
     *
     */
    @JSONField(name = "ibizsample0012id")
    @JsonProperty("ibizsample0012id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("订单标识")
    private String ibizsample0012id;


    /**
     * 设置 [IBIZSAMPLE0013NAME]
     */
    public void setIbizsample0013name(String  ibizsample0013name){
        this.ibizsample0013name = ibizsample0013name ;
        this.modify("ibizsample0013name",ibizsample0013name);
    }

    /**
     * 设置 [QUANTITY]
     */
    public void setQuantity(Integer  quantity){
        this.quantity = quantity ;
        this.modify("quantity",quantity);
    }

    /**
     * 设置 [IBIZUNIPRODUCTID]
     */
    public void setIbizuniproductid(String  ibizuniproductid){
        this.ibizuniproductid = ibizuniproductid ;
        this.modify("ibizuniproductid",ibizuniproductid);
    }

    /**
     * 设置 [IBIZSAMPLE0012ID]
     */
    public void setIbizsample0012id(String  ibizsample0012id){
        this.ibizsample0012id = ibizsample0012id ;
        this.modify("ibizsample0012id",ibizsample0012id);
    }


}


