package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0003DTO]
 */
@Data
@ApiModel("示例实体03")
public class IBIZSample0003DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBIZSAMPLE0003NAME]
     *
     */
    @JSONField(name = "ibizsample0003name")
    @JsonProperty("ibizsample0003name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("名称")
    private String ibizsample0003name;

    /**
     * 属性 [MEMO]
     *
     */
    @JSONField(name = "memo")
    @JsonProperty("memo")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    @ApiModelProperty("备注")
    private String memo;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("更新时间")
    private Timestamp updatedate;

    /**
     * 属性 [FIELD01]
     *
     */
    @JSONField(name = "field01")
    @JsonProperty("field01")
    @Size(min = 0, max = 4000, message = "内容长度必须小于等于[4000]")
    @ApiModelProperty("FIELD01")
    private String field01;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("建立时间")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("更新人")
    private String updateman;

    /**
     * 属性 [IBIZSAMPLE0003ID]
     *
     */
    @JSONField(name = "ibizsample0003id")
    @JsonProperty("ibizsample0003id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("IBIZSAMPLE0003标识")
    private String ibizsample0003id;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("建立人")
    private String createman;

    /**
     * 属性 [PIBIZSAMPLE0003NAME]
     *
     */
    @JSONField(name = "pibizsample0003name")
    @JsonProperty("pibizsample0003name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("上级")
    private String pibizsample0003name;

    /**
     * 属性 [PIBIZSAMPLE0003ID]
     *
     */
    @JSONField(name = "pibizsample0003id")
    @JsonProperty("pibizsample0003id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("IBIZSAMPLE0003标识")
    private String pibizsample0003id;


    /**
     * 设置 [IBIZSAMPLE0003NAME]
     */
    public void setIbizsample0003name(String  ibizsample0003name){
        this.ibizsample0003name = ibizsample0003name ;
        this.modify("ibizsample0003name",ibizsample0003name);
    }

    /**
     * 设置 [MEMO]
     */
    public void setMemo(String  memo){
        this.memo = memo ;
        this.modify("memo",memo);
    }

    /**
     * 设置 [FIELD01]
     */
    public void setField01(String  field01){
        this.field01 = field01 ;
        this.modify("field01",field01);
    }

    /**
     * 设置 [PIBIZSAMPLE0003ID]
     */
    public void setPibizsample0003id(String  pibizsample0003id){
        this.pibizsample0003id = pibizsample0003id ;
        this.modify("pibizsample0003id",pibizsample0003id);
    }


}


