package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZCustom;
import cn.ibizlab.core.sample.service.IIBIZCustomService;
import cn.ibizlab.core.sample.filter.IBIZCustomSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"自定义" })
@RestController("DemoAPI-ibizcustom")
@RequestMapping("")
public class IBIZCustomResource {

    @Autowired
    public IIBIZCustomService ibizcustomService;

    @Autowired
    @Lazy
    public IBIZCustomMapping ibizcustomMapping;

    @PreAuthorize("hasPermission(this.ibizcustomMapping.toDomain(#ibizcustomdto),'DemoSys-IBIZCustom-Create')")
    @ApiOperation(value = "新建自定义", tags = {"自定义" },  notes = "新建自定义")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustoms")
    public ResponseEntity<IBIZCustomDTO> create(@Validated @RequestBody IBIZCustomDTO ibizcustomdto) {
        IBIZCustom domain = ibizcustomMapping.toDomain(ibizcustomdto);
		ibizcustomService.create(domain);
        IBIZCustomDTO dto = ibizcustomMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizcustomMapping.toDomain(#ibizcustomdtos),'DemoSys-IBIZCustom-Create')")
    @ApiOperation(value = "批量新建自定义", tags = {"自定义" },  notes = "批量新建自定义")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustoms/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZCustomDTO> ibizcustomdtos) {
        ibizcustomService.createBatch(ibizcustomMapping.toDomain(ibizcustomdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizcustomMapping.toDomain(returnObject.body),'DemoSys-IBIZCustom-Get')")
    @ApiOperation(value = "获取自定义", tags = {"自定义" },  notes = "获取自定义")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizcustoms/{ibizcustom_id}")
    public ResponseEntity<IBIZCustomDTO> get(@PathVariable("ibizcustom_id") String ibizcustom_id) {
        IBIZCustom domain = ibizcustomService.get(ibizcustom_id);
        IBIZCustomDTO dto = ibizcustomMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizcustomService.get(#ibizcustom_id),'DemoSys-IBIZCustom-Remove')")
    @ApiOperation(value = "删除自定义", tags = {"自定义" },  notes = "删除自定义")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizcustoms/{ibizcustom_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizcustom_id") String ibizcustom_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizcustomService.remove(ibizcustom_id));
    }

    @PreAuthorize("hasPermission(this.ibizcustomService.getIbizcustomByIds(#ids),'DemoSys-IBIZCustom-Remove')")
    @ApiOperation(value = "批量删除自定义", tags = {"自定义" },  notes = "批量删除自定义")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizcustoms/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizcustomService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizcustom" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizcustomService.get(#ibizcustom_id),'DemoSys-IBIZCustom-Update')")
    @ApiOperation(value = "更新自定义", tags = {"自定义" },  notes = "更新自定义")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizcustoms/{ibizcustom_id}")
    public ResponseEntity<IBIZCustomDTO> update(@PathVariable("ibizcustom_id") String ibizcustom_id, @RequestBody IBIZCustomDTO ibizcustomdto) {
		IBIZCustom domain  = ibizcustomMapping.toDomain(ibizcustomdto);
        domain .setIbizcustomid(ibizcustom_id);
		ibizcustomService.update(domain );
		IBIZCustomDTO dto = ibizcustomMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizcustomService.getIbizcustomByEntities(this.ibizcustomMapping.toDomain(#ibizcustomdtos)),'DemoSys-IBIZCustom-Update')")
    @ApiOperation(value = "批量更新自定义", tags = {"自定义" },  notes = "批量更新自定义")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizcustoms/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZCustomDTO> ibizcustomdtos) {
        ibizcustomService.updateBatch(ibizcustomMapping.toDomain(ibizcustomdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查自定义", tags = {"自定义" },  notes = "检查自定义")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustoms/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZCustomDTO ibizcustomdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizcustomService.checkKey(ibizcustomMapping.toDomain(ibizcustomdto)));
    }

    @ApiOperation(value = "获取自定义草稿", tags = {"自定义" },  notes = "获取自定义草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizcustoms/getdraft")
    public ResponseEntity<IBIZCustomDTO> getDraft(IBIZCustomDTO dto) {
        IBIZCustom domain = ibizcustomMapping.toDomain(dto);
        return ResponseEntity.status(HttpStatus.OK).body(ibizcustomMapping.toDto(ibizcustomService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.ibizcustomMapping.toDomain(#ibizcustomdto),'DemoSys-IBIZCustom-Save')")
    @ApiOperation(value = "保存自定义", tags = {"自定义" },  notes = "保存自定义")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustoms/save")
    public ResponseEntity<IBIZCustomDTO> save(@RequestBody IBIZCustomDTO ibizcustomdto) {
        IBIZCustom domain = ibizcustomMapping.toDomain(ibizcustomdto);
        ibizcustomService.save(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizcustomMapping.toDto(domain));
    }

    @PreAuthorize("hasPermission(this.ibizcustomMapping.toDomain(#ibizcustomdtos),'DemoSys-IBIZCustom-Save')")
    @ApiOperation(value = "批量保存自定义", tags = {"自定义" },  notes = "批量保存自定义")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustoms/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZCustomDTO> ibizcustomdtos) {
        ibizcustomService.saveBatch(ibizcustomMapping.toDomain(ibizcustomdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustom-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZCustom-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"自定义" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizcustoms/fetchdefault")
	public ResponseEntity<List<IBIZCustomDTO>> fetchDefault(IBIZCustomSearchContext context) {
        Page<IBIZCustom> domains = ibizcustomService.searchDefault(context) ;
        List<IBIZCustomDTO> list = ibizcustomMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustom-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZCustom-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"自定义" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizcustoms/searchdefault")
	public ResponseEntity<Page<IBIZCustomDTO>> searchDefault(@RequestBody IBIZCustomSearchContext context) {
        Page<IBIZCustom> domains = ibizcustomService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizcustomMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



}

