import { Http,Util } from '@/utils';
import ParamsUILogicBase from './params-ui-logic-base';

/**
 * 准备参数
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic.ts.ftl 生成
 * @export
 * @class ParamsUILogic
 */
export default class ParamsUILogic extends ParamsUILogicBase {

    /**
     * 准备参数 逻辑实例对象
     *
     * @private
     * @static
     * @type {ParamsUILogic}
     * @memberof ParamsUILogic
     */
    private static instance: ParamsUILogic;

    /**
     * 获取 准备参数 逻辑实例对象
     *
     * @static
     * @return {*}  {ParamsUILogic}
     * @memberof ParamsUILogic
     */
    static getInstance(): ParamsUILogic {
        if (!this.instance) {
            this.instance = new ParamsUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  ParamsUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  ParamsUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}