package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0017;
import cn.ibizlab.core.sample.service.IIBIZSample0017Service;
import cn.ibizlab.core.sample.filter.IBIZSample0017SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单" })
@RestController("DemoAPI-ibizsample0017")
@RequestMapping("")
public class IBIZSample0017Resource {

    @Autowired
    public IIBIZSample0017Service ibizsample0017Service;

    @Autowired
    @Lazy
    public IBIZSample0017Mapping ibizsample0017Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0017Mapping.toDomain(#ibizsample0017dto),'DemoSys-IBIZSample0017-Create')")
    @ApiOperation(value = "新建订单", tags = {"订单" },  notes = "新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0017s")
    public ResponseEntity<IBIZSample0017DTO> create(@Validated @RequestBody IBIZSample0017DTO ibizsample0017dto) {
        IBIZSample0017 domain = ibizsample0017Mapping.toDomain(ibizsample0017dto);
		ibizsample0017Service.create(domain);
        IBIZSample0017DTO dto = ibizsample0017Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0017Mapping.toDomain(#ibizsample0017dtos),'DemoSys-IBIZSample0017-Create')")
    @ApiOperation(value = "批量新建订单", tags = {"订单" },  notes = "批量新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0017s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0017DTO> ibizsample0017dtos) {
        ibizsample0017Service.createBatch(ibizsample0017Mapping.toDomain(ibizsample0017dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0017" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0017Service.get(#ibizsample0017_id),'DemoSys-IBIZSample0017-Update')")
    @ApiOperation(value = "更新订单", tags = {"订单" },  notes = "更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0017s/{ibizsample0017_id}")
    public ResponseEntity<IBIZSample0017DTO> update(@PathVariable("ibizsample0017_id") String ibizsample0017_id, @RequestBody IBIZSample0017DTO ibizsample0017dto) {
		IBIZSample0017 domain  = ibizsample0017Mapping.toDomain(ibizsample0017dto);
        domain .setIbizsample0017id(ibizsample0017_id);
		ibizsample0017Service.update(domain );
		IBIZSample0017DTO dto = ibizsample0017Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0017Service.getIbizsample0017ByEntities(this.ibizsample0017Mapping.toDomain(#ibizsample0017dtos)),'DemoSys-IBIZSample0017-Update')")
    @ApiOperation(value = "批量更新订单", tags = {"订单" },  notes = "批量更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0017s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0017DTO> ibizsample0017dtos) {
        ibizsample0017Service.updateBatch(ibizsample0017Mapping.toDomain(ibizsample0017dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0017Service.get(#ibizsample0017_id),'DemoSys-IBIZSample0017-Remove')")
    @ApiOperation(value = "删除订单", tags = {"订单" },  notes = "删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0017s/{ibizsample0017_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0017_id") String ibizsample0017_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0017Service.remove(ibizsample0017_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0017Service.getIbizsample0017ByIds(#ids),'DemoSys-IBIZSample0017-Remove')")
    @ApiOperation(value = "批量删除订单", tags = {"订单" },  notes = "批量删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0017s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0017Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0017Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0017-Get')")
    @ApiOperation(value = "获取订单", tags = {"订单" },  notes = "获取订单")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0017s/{ibizsample0017_id}")
    public ResponseEntity<IBIZSample0017DTO> get(@PathVariable("ibizsample0017_id") String ibizsample0017_id) {
        IBIZSample0017 domain = ibizsample0017Service.get(ibizsample0017_id);
        IBIZSample0017DTO dto = ibizsample0017Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取订单草稿", tags = {"订单" },  notes = "获取订单草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0017s/getdraft")
    public ResponseEntity<IBIZSample0017DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0017Mapping.toDto(ibizsample0017Service.getDraft(new IBIZSample0017())));
    }

    @ApiOperation(value = "检查订单", tags = {"订单" },  notes = "检查订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0017s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0017DTO ibizsample0017dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0017Service.checkKey(ibizsample0017Mapping.toDomain(ibizsample0017dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0017Mapping.toDomain(#ibizsample0017dto),'DemoSys-IBIZSample0017-Save')")
    @ApiOperation(value = "保存订单", tags = {"订单" },  notes = "保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0017s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0017DTO ibizsample0017dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0017Service.save(ibizsample0017Mapping.toDomain(ibizsample0017dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0017Mapping.toDomain(#ibizsample0017dtos),'DemoSys-IBIZSample0017-Save')")
    @ApiOperation(value = "批量保存订单", tags = {"订单" },  notes = "批量保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0017s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0017DTO> ibizsample0017dtos) {
        ibizsample0017Service.saveBatch(ibizsample0017Mapping.toDomain(ibizsample0017dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0017-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0017-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"订单" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsample0017s/fetchdefault")
	public ResponseEntity<List<IBIZSample0017DTO>> fetchDefault(IBIZSample0017SearchContext context) {
        Page<IBIZSample0017> domains = ibizsample0017Service.searchDefault(context) ;
        List<IBIZSample0017DTO> list = ibizsample0017Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0017-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0017-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"订单" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0017s/searchdefault")
	public ResponseEntity<Page<IBIZSample0017DTO>> searchDefault(@RequestBody IBIZSample0017SearchContext context) {
        Page<IBIZSample0017> domains = ibizsample0017Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0017Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0017-searchFormType-all') and hasPermission(#context,'DemoSys-IBIZSample0017-Get')")
	@ApiOperation(value = "获取FormType", tags = {"订单" } ,notes = "获取FormType")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsample0017s/fetchformtype")
	public ResponseEntity<List<IBIZSample0017DTO>> fetchFormType(IBIZSample0017SearchContext context) {
        Page<IBIZSample0017> domains = ibizsample0017Service.searchFormType(context) ;
        List<IBIZSample0017DTO> list = ibizsample0017Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0017-searchFormType-all') and hasPermission(#context,'DemoSys-IBIZSample0017-Get')")
	@ApiOperation(value = "查询FormType", tags = {"订单" } ,notes = "查询FormType")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0017s/searchformtype")
	public ResponseEntity<Page<IBIZSample0017DTO>> searchFormType(@RequestBody IBIZSample0017SearchContext context) {
        Page<IBIZSample0017> domains = ibizsample0017Service.searchFormType(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0017Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

