package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0010;
import cn.ibizlab.core.sample.service.IIBIZSample0010Service;
import cn.ibizlab.core.sample.filter.IBIZSample0010SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单" })
@RestController("DemoAPI-ibizsample0010")
@RequestMapping("")
public class IBIZSample0010Resource {

    @Autowired
    public IIBIZSample0010Service ibizsample0010Service;

    @Autowired
    @Lazy
    public IBIZSample0010Mapping ibizsample0010Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0010Mapping.toDomain(#ibizsample0010dto),'DemoSys-IBIZSample0010-Create')")
    @ApiOperation(value = "新建订单", tags = {"订单" },  notes = "新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0010s")
    public ResponseEntity<IBIZSample0010DTO> create(@Validated @RequestBody IBIZSample0010DTO ibizsample0010dto) {
        IBIZSample0010 domain = ibizsample0010Mapping.toDomain(ibizsample0010dto);
		ibizsample0010Service.create(domain);
        IBIZSample0010DTO dto = ibizsample0010Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0010Mapping.toDomain(#ibizsample0010dtos),'DemoSys-IBIZSample0010-Create')")
    @ApiOperation(value = "批量新建订单", tags = {"订单" },  notes = "批量新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0010s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0010DTO> ibizsample0010dtos) {
        ibizsample0010Service.createBatch(ibizsample0010Mapping.toDomain(ibizsample0010dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0010" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0010Service.get(#ibizsample0010_id),'DemoSys-IBIZSample0010-Update')")
    @ApiOperation(value = "更新订单", tags = {"订单" },  notes = "更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0010s/{ibizsample0010_id}")
    public ResponseEntity<IBIZSample0010DTO> update(@PathVariable("ibizsample0010_id") String ibizsample0010_id, @RequestBody IBIZSample0010DTO ibizsample0010dto) {
		IBIZSample0010 domain  = ibizsample0010Mapping.toDomain(ibizsample0010dto);
        domain .setIbizsample0010id(ibizsample0010_id);
		ibizsample0010Service.update(domain );
		IBIZSample0010DTO dto = ibizsample0010Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0010Service.getIbizsample0010ByEntities(this.ibizsample0010Mapping.toDomain(#ibizsample0010dtos)),'DemoSys-IBIZSample0010-Update')")
    @ApiOperation(value = "批量更新订单", tags = {"订单" },  notes = "批量更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0010s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0010DTO> ibizsample0010dtos) {
        ibizsample0010Service.updateBatch(ibizsample0010Mapping.toDomain(ibizsample0010dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0010Service.get(#ibizsample0010_id),'DemoSys-IBIZSample0010-Remove')")
    @ApiOperation(value = "删除订单", tags = {"订单" },  notes = "删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0010s/{ibizsample0010_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0010_id") String ibizsample0010_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0010Service.remove(ibizsample0010_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0010Service.getIbizsample0010ByIds(#ids),'DemoSys-IBIZSample0010-Remove')")
    @ApiOperation(value = "批量删除订单", tags = {"订单" },  notes = "批量删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0010s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0010Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0010Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0010-Get')")
    @ApiOperation(value = "获取订单", tags = {"订单" },  notes = "获取订单")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0010s/{ibizsample0010_id}")
    public ResponseEntity<IBIZSample0010DTO> get(@PathVariable("ibizsample0010_id") String ibizsample0010_id) {
        IBIZSample0010 domain = ibizsample0010Service.get(ibizsample0010_id);
        IBIZSample0010DTO dto = ibizsample0010Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取订单草稿", tags = {"订单" },  notes = "获取订单草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0010s/getdraft")
    public ResponseEntity<IBIZSample0010DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0010Mapping.toDto(ibizsample0010Service.getDraft(new IBIZSample0010())));
    }

    @ApiOperation(value = "检查订单", tags = {"订单" },  notes = "检查订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0010s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0010DTO ibizsample0010dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0010Service.checkKey(ibizsample0010Mapping.toDomain(ibizsample0010dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0010Mapping.toDomain(#ibizsample0010dto),'DemoSys-IBIZSample0010-Save')")
    @ApiOperation(value = "保存订单", tags = {"订单" },  notes = "保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0010s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0010DTO ibizsample0010dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0010Service.save(ibizsample0010Mapping.toDomain(ibizsample0010dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0010Mapping.toDomain(#ibizsample0010dtos),'DemoSys-IBIZSample0010-Save')")
    @ApiOperation(value = "批量保存订单", tags = {"订单" },  notes = "批量保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0010s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0010DTO> ibizsample0010dtos) {
        ibizsample0010Service.saveBatch(ibizsample0010Mapping.toDomain(ibizsample0010dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0010-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0010-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"订单" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsample0010s/fetchdefault")
	public ResponseEntity<List<IBIZSample0010DTO>> fetchDefault(IBIZSample0010SearchContext context) {
        Page<IBIZSample0010> domains = ibizsample0010Service.searchDefault(context) ;
        List<IBIZSample0010DTO> list = ibizsample0010Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0010-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0010-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"订单" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0010s/searchdefault")
	public ResponseEntity<Page<IBIZSample0010DTO>> searchDefault(@RequestBody IBIZSample0010SearchContext context) {
        Page<IBIZSample0010> domains = ibizsample0010Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0010Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

