package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZAPPCTRLDTO]
 */
@Data
public class IBIZAPPCTRLDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBIZAPPCTRLNAME]
     *
     */
    @JSONField(name = "ibizappctrlname")
    @JsonProperty("ibizappctrlname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizappctrlname;

    /**
     * 属性 [IBIZAPPCTRLID]
     *
     */
    @JSONField(name = "ibizappctrlid")
    @JsonProperty("ibizappctrlid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizappctrlid;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [IBIZAPPCTRLTYPE]
     *
     */
    @JSONField(name = "ibizappctrltype")
    @JsonProperty("ibizappctrltype")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizappctrltype;

    /**
     * 属性 [CTRLDESCRIPTION]
     *
     */
    @JSONField(name = "ctrldescription")
    @JsonProperty("ctrldescription")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ctrldescription;


    /**
     * 设置 [IBIZAPPCTRLNAME]
     */
    public void setIbizappctrlname(String  ibizappctrlname){
        this.ibizappctrlname = ibizappctrlname ;
        this.modify("ibizappctrlname",ibizappctrlname);
    }

    /**
     * 设置 [IBIZAPPCTRLTYPE]
     */
    public void setIbizappctrltype(String  ibizappctrltype){
        this.ibizappctrltype = ibizappctrltype ;
        this.modify("ibizappctrltype",ibizappctrltype);
    }

    /**
     * 设置 [CTRLDESCRIPTION]
     */
    public void setCtrldescription(String  ctrldescription){
        this.ctrldescription = ctrldescription ;
        this.modify("ctrldescription",ctrldescription);
    }


}


