package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBZ5Sample0012DTO]
 */
@Data
public class IBZ5Sample0012DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [MEMO]
     *
     */
    @JSONField(name = "memo")
    @JsonProperty("memo")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    private String memo;

    /**
     * 属性 [IBZ5SAMPLE0012ID]
     *
     */
    @JSONField(name = "ibz5sample0012id")
    @JsonProperty("ibz5sample0012id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5sample0012id;

    /**
     * 属性 [IBZ5SAMPLE0012NAME]
     *
     */
    @JSONField(name = "ibz5sample0012name")
    @JsonProperty("ibz5sample0012name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5sample0012name;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [ORDERUID]
     *
     */
    @JSONField(name = "orderuid")
    @JsonProperty("orderuid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String orderuid;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [ORDERTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "ordertime" , format="yyyy-MM-dd")
    @JsonProperty("ordertime")
    private Timestamp ordertime;

    /**
     * 属性 [ORDERTYPE]
     *
     */
    @JSONField(name = "ordertype")
    @JsonProperty("ordertype")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String ordertype;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;


    /**
     * 设置 [MEMO]
     */
    public void setMemo(String  memo){
        this.memo = memo ;
        this.modify("memo",memo);
    }

    /**
     * 设置 [IBZ5SAMPLE0012NAME]
     */
    public void setIbz5sample0012name(String  ibz5sample0012name){
        this.ibz5sample0012name = ibz5sample0012name ;
        this.modify("ibz5sample0012name",ibz5sample0012name);
    }

    /**
     * 设置 [ORDERUID]
     */
    public void setOrderuid(String  orderuid){
        this.orderuid = orderuid ;
        this.modify("orderuid",orderuid);
    }

    /**
     * 设置 [ORDERTIME]
     */
    public void setOrdertime(Timestamp  ordertime){
        this.ordertime = ordertime ;
        this.modify("ordertime",ordertime);
    }

    /**
     * 设置 [ORDERTYPE]
     */
    public void setOrdertype(String  ordertype){
        this.ordertype = ordertype ;
        this.modify("ordertype",ordertype);
    }


}


