package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBZ5Sample0008DTO]
 */
@Data
public class IBZ5Sample0008DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [YWSTATE]
     *
     */
    @JSONField(name = "ywstate")
    @JsonProperty("ywstate")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String ywstate;

    /**
     * 属性 [NEXTPERSON]
     *
     */
    @JSONField(name = "nextperson")
    @JsonProperty("nextperson")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String nextperson;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [IBZ5SAMPLE0008NAME]
     *
     */
    @JSONField(name = "ibz5sample0008name")
    @JsonProperty("ibz5sample0008name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5sample0008name;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [WFINSTANCEID]
     *
     */
    @JSONField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String wfinstanceid;

    /**
     * 属性 [IBZ5SAMPLE0008ID]
     *
     */
    @JSONField(name = "ibz5sample0008id")
    @JsonProperty("ibz5sample0008id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5sample0008id;

    /**
     * 属性 [WFSTEP]
     *
     */
    @JSONField(name = "wfstep")
    @JsonProperty("wfstep")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String wfstep;

    /**
     * 属性 [WFVERSION]
     *
     */
    @JSONField(name = "wfversion")
    @JsonProperty("wfversion")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String wfversion;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [WFSTATE]
     *
     */
    @JSONField(name = "wfstate")
    @JsonProperty("wfstate")
    private Integer wfstate;


    /**
     * 设置 [YWSTATE]
     */
    public void setYwstate(String  ywstate){
        this.ywstate = ywstate ;
        this.modify("ywstate",ywstate);
    }

    /**
     * 设置 [NEXTPERSON]
     */
    public void setNextperson(String  nextperson){
        this.nextperson = nextperson ;
        this.modify("nextperson",nextperson);
    }

    /**
     * 设置 [IBZ5SAMPLE0008NAME]
     */
    public void setIbz5sample0008name(String  ibz5sample0008name){
        this.ibz5sample0008name = ibz5sample0008name ;
        this.modify("ibz5sample0008name",ibz5sample0008name);
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.modify("wfinstanceid",wfinstanceid);
    }

    /**
     * 设置 [WFSTEP]
     */
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.modify("wfstep",wfstep);
    }

    /**
     * 设置 [WFVERSION]
     */
    public void setWfversion(String  wfversion){
        this.wfversion = wfversion ;
        this.modify("wfversion",wfversion);
    }

    /**
     * 设置 [WFSTATE]
     */
    public void setWfstate(Integer  wfstate){
        this.wfstate = wfstate ;
        this.modify("wfstate",wfstate);
    }


}


