package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBZ5Sample0004DTO]
 */
@Data
public class IBZ5Sample0004DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [WFSTATE]
     *
     */
    @JSONField(name = "wfstate")
    @JsonProperty("wfstate")
    private Integer wfstate;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [IBZ5SAMPLE0004NAME]
     *
     */
    @JSONField(name = "ibz5sample0004name")
    @JsonProperty("ibz5sample0004name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5sample0004name;

    /**
     * 属性 [MVDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "mvdate" , format="yyyy-MM-dd")
    @JsonProperty("mvdate")
    private Timestamp mvdate;

    /**
     * 属性 [WFINSTANCEID]
     *
     */
    @JSONField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String wfinstanceid;

    /**
     * 属性 [WFMVSTEP]
     *
     */
    @JSONField(name = "wfmvstep")
    @JsonProperty("wfmvstep")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String wfmvstep;

    /**
     * 属性 [WFVERSION]
     *
     */
    @JSONField(name = "wfversion")
    @JsonProperty("wfversion")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String wfversion;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [IBZ5SAMPLE0004ID]
     *
     */
    @JSONField(name = "ibz5sample0004id")
    @JsonProperty("ibz5sample0004id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5sample0004id;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [WFMVTYPE]
     *
     */
    @JSONField(name = "wfmvtype")
    @JsonProperty("wfmvtype")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String wfmvtype;

    /**
     * 属性 [WFMVSTATE]
     *
     */
    @JSONField(name = "wfmvstate")
    @JsonProperty("wfmvstate")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String wfmvstate;

    /**
     * 属性 [MEMO]
     *
     */
    @JSONField(name = "memo")
    @JsonProperty("memo")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    private String memo;

    /**
     * 属性 [JE]
     *
     */
    @JSONField(name = "je")
    @JsonProperty("je")
    private BigDecimal je;


    /**
     * 设置 [WFSTATE]
     */
    public void setWfstate(Integer  wfstate){
        this.wfstate = wfstate ;
        this.modify("wfstate",wfstate);
    }

    /**
     * 设置 [IBZ5SAMPLE0004NAME]
     */
    public void setIbz5sample0004name(String  ibz5sample0004name){
        this.ibz5sample0004name = ibz5sample0004name ;
        this.modify("ibz5sample0004name",ibz5sample0004name);
    }

    /**
     * 设置 [MVDATE]
     */
    public void setMvdate(Timestamp  mvdate){
        this.mvdate = mvdate ;
        this.modify("mvdate",mvdate);
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.modify("wfinstanceid",wfinstanceid);
    }

    /**
     * 设置 [WFMVSTEP]
     */
    public void setWfmvstep(String  wfmvstep){
        this.wfmvstep = wfmvstep ;
        this.modify("wfmvstep",wfmvstep);
    }

    /**
     * 设置 [WFVERSION]
     */
    public void setWfversion(String  wfversion){
        this.wfversion = wfversion ;
        this.modify("wfversion",wfversion);
    }

    /**
     * 设置 [WFMVTYPE]
     */
    public void setWfmvtype(String  wfmvtype){
        this.wfmvtype = wfmvtype ;
        this.modify("wfmvtype",wfmvtype);
    }

    /**
     * 设置 [WFMVSTATE]
     */
    public void setWfmvstate(String  wfmvstate){
        this.wfmvstate = wfmvstate ;
        this.modify("wfmvstate",wfmvstate);
    }

    /**
     * 设置 [MEMO]
     */
    public void setMemo(String  memo){
        this.memo = memo ;
        this.modify("memo",memo);
    }

    /**
     * 设置 [JE]
     */
    public void setJe(BigDecimal  je){
        this.je = je ;
        this.modify("je",je);
    }


}


