package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBZ5Sample0001DTO]
 */
@Data
public class IBZ5Sample0001DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [FIELD01]
     *
     */
    @JSONField(name = "field01")
    @JsonProperty("field01")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String field01;

    /**
     * 属性 [FIELD02]
     *
     */
    @JSONField(name = "field02")
    @JsonProperty("field02")
    @Size(min = 0, max = 1000, message = "内容长度必须小于等于[1000]")
    private String field02;

    /**
     * 属性 [FIELD03]
     *
     */
    @JSONField(name = "field03")
    @JsonProperty("field03")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String field03;

    /**
     * 属性 [FIELD04]
     *
     */
    @JSONField(name = "field04")
    @JsonProperty("field04")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String field04;

    /**
     * 属性 [FIELD05]
     *
     */
    @JSONField(name = "field05")
    @JsonProperty("field05")
    private Integer field05;

    /**
     * 属性 [FIELD06]
     *
     */
    @JSONField(name = "field06")
    @JsonProperty("field06")
    private Double field06;

    /**
     * 属性 [FIELD07]
     *
     */
    @JSONField(name = "field07")
    @JsonProperty("field07")
    private BigDecimal field07;

    /**
     * 属性 [FIELD08]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "field08" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("field08")
    private Timestamp field08;

    /**
     * 属性 [FIELD09]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "field09" , format="yyyy-MM-dd")
    @JsonProperty("field09")
    private Timestamp field09;

    /**
     * 属性 [FIELD10]
     *
     */
    @JsonFormat(pattern="HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "field10" , format="HH:mm:ss")
    @JsonProperty("field10")
    private Timestamp field10;

    /**
     * 属性 [FIELD11]
     *
     */
    @JSONField(name = "field11")
    @JsonProperty("field11")
    private Integer field11;

    /**
     * 属性 [FIELD12]
     *
     */
    @JSONField(name = "field12")
    @JsonProperty("field12")
    private Integer field12;

    /**
     * 属性 [FIELD13]
     *
     */
    @JSONField(name = "field13")
    @JsonProperty("field13")
    private Integer field13;

    /**
     * 属性 [FIELD14]
     *
     */
    @JSONField(name = "field14")
    @JsonProperty("field14")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String field14;

    /**
     * 属性 [FIELD15]
     *
     */
    @JSONField(name = "field15")
    @JsonProperty("field15")
    private Integer field15;

    /**
     * 属性 [FIELD16]
     *
     */
    @JSONField(name = "field16")
    @JsonProperty("field16")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String field16;

    /**
     * 属性 [FIELD24]
     *
     */
    @JSONField(name = "field24")
    @JsonProperty("field24")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String field24;

    /**
     * 属性 [FIELD17]
     *
     */
    @JSONField(name = "field17")
    @JsonProperty("field17")
    private Integer field17;

    /**
     * 属性 [FIELD18]
     *
     */
    @JSONField(name = "field18")
    @JsonProperty("field18")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String field18;

    /**
     * 属性 [FIELD19]
     *
     */
    @JSONField(name = "field19")
    @JsonProperty("field19")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String field19;

    /**
     * 属性 [FIELD20]
     *
     */
    @JSONField(name = "field20")
    @JsonProperty("field20")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String field20;

    /**
     * 属性 [FIELD21]
     *
     */
    @JSONField(name = "field21")
    @JsonProperty("field21")
    private Timestamp field21;

    /**
     * 属性 [FIELD22]
     *
     */
    @JSONField(name = "field22")
    @JsonProperty("field22")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String field22;

    /**
     * 属性 [FIELD27]
     *
     */
    @JSONField(name = "field27")
    @JsonProperty("field27")
    private Integer field27;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [IBZ5SAMPLE0001ID]
     *
     */
    @JSONField(name = "ibz5sample0001id")
    @JsonProperty("ibz5sample0001id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5sample0001id;

    /**
     * 属性 [IBZ5SAMPLE0001NAME]
     *
     */
    @JSONField(name = "ibz5sample0001name")
    @JsonProperty("ibz5sample0001name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5sample0001name;


    /**
     * 设置 [FIELD01]
     */
    public void setField01(String  field01){
        this.field01 = field01 ;
        this.modify("field01",field01);
    }

    /**
     * 设置 [FIELD02]
     */
    public void setField02(String  field02){
        this.field02 = field02 ;
        this.modify("field02",field02);
    }

    /**
     * 设置 [FIELD03]
     */
    public void setField03(String  field03){
        this.field03 = field03 ;
        this.modify("field03",field03);
    }

    /**
     * 设置 [FIELD04]
     */
    public void setField04(String  field04){
        this.field04 = field04 ;
        this.modify("field04",field04);
    }

    /**
     * 设置 [FIELD05]
     */
    public void setField05(Integer  field05){
        this.field05 = field05 ;
        this.modify("field05",field05);
    }

    /**
     * 设置 [FIELD06]
     */
    public void setField06(Double  field06){
        this.field06 = field06 ;
        this.modify("field06",field06);
    }

    /**
     * 设置 [FIELD07]
     */
    public void setField07(BigDecimal  field07){
        this.field07 = field07 ;
        this.modify("field07",field07);
    }

    /**
     * 设置 [FIELD08]
     */
    public void setField08(Timestamp  field08){
        this.field08 = field08 ;
        this.modify("field08",field08);
    }

    /**
     * 设置 [FIELD09]
     */
    public void setField09(Timestamp  field09){
        this.field09 = field09 ;
        this.modify("field09",field09);
    }

    /**
     * 设置 [FIELD10]
     */
    public void setField10(Timestamp  field10){
        this.field10 = field10 ;
        this.modify("field10",field10);
    }

    /**
     * 设置 [FIELD11]
     */
    public void setField11(Integer  field11){
        this.field11 = field11 ;
        this.modify("field11",field11);
    }

    /**
     * 设置 [FIELD12]
     */
    public void setField12(Integer  field12){
        this.field12 = field12 ;
        this.modify("field12",field12);
    }

    /**
     * 设置 [FIELD13]
     */
    public void setField13(Integer  field13){
        this.field13 = field13 ;
        this.modify("field13",field13);
    }

    /**
     * 设置 [FIELD14]
     */
    public void setField14(String  field14){
        this.field14 = field14 ;
        this.modify("field14",field14);
    }

    /**
     * 设置 [FIELD15]
     */
    public void setField15(Integer  field15){
        this.field15 = field15 ;
        this.modify("field15",field15);
    }

    /**
     * 设置 [FIELD16]
     */
    public void setField16(String  field16){
        this.field16 = field16 ;
        this.modify("field16",field16);
    }

    /**
     * 设置 [FIELD24]
     */
    public void setField24(String  field24){
        this.field24 = field24 ;
        this.modify("field24",field24);
    }

    /**
     * 设置 [FIELD17]
     */
    public void setField17(Integer  field17){
        this.field17 = field17 ;
        this.modify("field17",field17);
    }

    /**
     * 设置 [FIELD18]
     */
    public void setField18(String  field18){
        this.field18 = field18 ;
        this.modify("field18",field18);
    }

    /**
     * 设置 [FIELD19]
     */
    public void setField19(String  field19){
        this.field19 = field19 ;
        this.modify("field19",field19);
    }

    /**
     * 设置 [FIELD20]
     */
    public void setField20(String  field20){
        this.field20 = field20 ;
        this.modify("field20",field20);
    }

    /**
     * 设置 [FIELD21]
     */
    public void setField21(Timestamp  field21){
        this.field21 = field21 ;
        this.modify("field21",field21);
    }

    /**
     * 设置 [FIELD22]
     */
    public void setField22(String  field22){
        this.field22 = field22 ;
        this.modify("field22",field22);
    }

    /**
     * 设置 [FIELD27]
     */
    public void setField27(Integer  field27){
        this.field27 = field27 ;
        this.modify("field27",field27);
    }

    /**
     * 设置 [IBZ5SAMPLE0001NAME]
     */
    public void setIbz5sample0001name(String  ibz5sample0001name){
        this.ibz5sample0001name = ibz5sample0001name ;
        this.modify("ibz5sample0001name",ibz5sample0001name);
    }


}


