package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBZ5OrderDetailDTO]
 */
@Data
public class IBZ5OrderDetailDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBZ5ORDERDETAILA]
     *
     */
    @JSONField(name = "ibz5orderdetaila")
    @JsonProperty("ibz5orderdetaila")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5orderdetaila;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [IBZ5ORDERDETAILNAME]
     *
     */
    @JSONField(name = "ibz5orderdetailname")
    @JsonProperty("ibz5orderdetailname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5orderdetailname;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [QUANTITY]
     *
     */
    @JSONField(name = "quantity")
    @JsonProperty("quantity")
    private Integer quantity;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [AMOUNT]
     *
     */
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private Double amount;

    /**
     * 属性 [IBZ5ORDERDETAILID]
     *
     */
    @JSONField(name = "ibz5orderdetailid")
    @JsonProperty("ibz5orderdetailid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5orderdetailid;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [IBZ5UNIPRODUCTNAME]
     *
     */
    @JSONField(name = "ibz5uniproductname")
    @JsonProperty("ibz5uniproductname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5uniproductname;

    /**
     * 属性 [IBZ5ORDERNAME]
     *
     */
    @JSONField(name = "ibz5ordername")
    @JsonProperty("ibz5ordername")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5ordername;

    /**
     * 属性 [UNITPRICE]
     *
     */
    @JSONField(name = "unitprice")
    @JsonProperty("unitprice")
    private Double unitprice;

    /**
     * 属性 [UNIT]
     *
     */
    @JSONField(name = "unit")
    @JsonProperty("unit")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String unit;

    /**
     * 属性 [ORDERUID]
     *
     */
    @JSONField(name = "orderuid")
    @JsonProperty("orderuid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String orderuid;

    /**
     * 属性 [IBZ5UNIPRODUCTID]
     *
     */
    @JSONField(name = "ibz5uniproductid")
    @JsonProperty("ibz5uniproductid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5uniproductid;

    /**
     * 属性 [IBZ5ORDERID]
     *
     */
    @JSONField(name = "ibz5orderid")
    @JsonProperty("ibz5orderid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5orderid;


    /**
     * 设置 [IBZ5ORDERDETAILA]
     */
    public void setIbz5orderdetaila(String  ibz5orderdetaila){
        this.ibz5orderdetaila = ibz5orderdetaila ;
        this.modify("ibz5orderdetaila",ibz5orderdetaila);
    }

    /**
     * 设置 [IBZ5ORDERDETAILNAME]
     */
    public void setIbz5orderdetailname(String  ibz5orderdetailname){
        this.ibz5orderdetailname = ibz5orderdetailname ;
        this.modify("ibz5orderdetailname",ibz5orderdetailname);
    }

    /**
     * 设置 [QUANTITY]
     */
    public void setQuantity(Integer  quantity){
        this.quantity = quantity ;
        this.modify("quantity",quantity);
    }

    /**
     * 设置 [IBZ5UNIPRODUCTID]
     */
    public void setIbz5uniproductid(String  ibz5uniproductid){
        this.ibz5uniproductid = ibz5uniproductid ;
        this.modify("ibz5uniproductid",ibz5uniproductid);
    }

    /**
     * 设置 [IBZ5ORDERID]
     */
    public void setIbz5orderid(String  ibz5orderid){
        this.ibz5orderid = ibz5orderid ;
        this.modify("ibz5orderid",ibz5orderid);
    }


}


