package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBZ5HardwareDTO]
 */
@Data
public class IBZ5HardwareDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [IBZ5HARDWAREID]
     *
     */
    @JSONField(name = "ibz5hardwareid")
    @JsonProperty("ibz5hardwareid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5hardwareid;

    /**
     * 属性 [PRODUCER]
     *
     */
    @JSONField(name = "producer")
    @JsonProperty("producer")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    private String producer;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [PRODUCTUID]
     *
     */
    @JSONField(name = "productuid")
    @JsonProperty("productuid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String productuid;

    /**
     * 属性 [UNIT]
     *
     */
    @JSONField(name = "unit")
    @JsonProperty("unit")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String unit;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [IBZ5HARDWARETYPE]
     *
     */
    @JSONField(name = "ibz5hardwaretype")
    @JsonProperty("ibz5hardwaretype")
    @NotBlank(message = "[分组类型]不允许为空!")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5hardwaretype;

    /**
     * 属性 [IBZ5HARDWARENAME]
     *
     */
    @JSONField(name = "ibz5hardwarename")
    @JsonProperty("ibz5hardwarename")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5hardwarename;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [UNITPRICE]
     *
     */
    @JSONField(name = "unitprice")
    @JsonProperty("unitprice")
    private Double unitprice;


    /**
     * 设置 [PRODUCER]
     */
    public void setProducer(String  producer){
        this.producer = producer ;
        this.modify("producer",producer);
    }

    /**
     * 设置 [PRODUCTUID]
     */
    public void setProductuid(String  productuid){
        this.productuid = productuid ;
        this.modify("productuid",productuid);
    }

    /**
     * 设置 [UNIT]
     */
    public void setUnit(String  unit){
        this.unit = unit ;
        this.modify("unit",unit);
    }

    /**
     * 设置 [IBZ5HARDWARETYPE]
     */
    public void setIbz5hardwaretype(String  ibz5hardwaretype){
        this.ibz5hardwaretype = ibz5hardwaretype ;
        this.modify("ibz5hardwaretype",ibz5hardwaretype);
    }

    /**
     * 设置 [IBZ5HARDWARENAME]
     */
    public void setIbz5hardwarename(String  ibz5hardwarename){
        this.ibz5hardwarename = ibz5hardwarename ;
        this.modify("ibz5hardwarename",ibz5hardwarename);
    }

    /**
     * 设置 [UNITPRICE]
     */
    public void setUnitprice(Double  unitprice){
        this.unitprice = unitprice ;
        this.modify("unitprice",unitprice);
    }


}


