package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBZ5UNIProductDTO]
 */
@Data
public class IBZ5UNIProductDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBZ5UNIPRODUCTNAME]
     *
     */
    @JSONField(name = "ibz5uniproductname")
    @JsonProperty("ibz5uniproductname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5uniproductname;

    /**
     * 属性 [IBZ5UNIPRODUCTTYPE]
     *
     */
    @JSONField(name = "ibz5uniproducttype")
    @JsonProperty("ibz5uniproducttype")
    @NotBlank(message = "[分组类型]不允许为空!")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5uniproducttype;

    /**
     * 属性 [IBZ5UNIPRODUCTID]
     *
     */
    @JSONField(name = "ibz5uniproductid")
    @JsonProperty("ibz5uniproductid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5uniproductid;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [UNIT]
     *
     */
    @JSONField(name = "unit")
    @JsonProperty("unit")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String unit;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [UNITPRICE]
     *
     */
    @JSONField(name = "unitprice")
    @JsonProperty("unitprice")
    private Double unitprice;


    /**
     * 设置 [IBZ5UNIPRODUCTNAME]
     */
    public void setIbz5uniproductname(String  ibz5uniproductname){
        this.ibz5uniproductname = ibz5uniproductname ;
        this.modify("ibz5uniproductname",ibz5uniproductname);
    }

    /**
     * 设置 [IBZ5UNIPRODUCTTYPE]
     */
    public void setIbz5uniproducttype(String  ibz5uniproducttype){
        this.ibz5uniproducttype = ibz5uniproducttype ;
        this.modify("ibz5uniproducttype",ibz5uniproducttype);
    }

    /**
     * 设置 [UNIT]
     */
    public void setUnit(String  unit){
        this.unit = unit ;
        this.modify("unit",unit);
    }

    /**
     * 设置 [UNITPRICE]
     */
    public void setUnitprice(Double  unitprice){
        this.unitprice = unitprice ;
        this.modify("unitprice",unitprice);
    }


}


