package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBZ5Sample0016DTO]
 */
@Data
public class IBZ5Sample0016DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [IBZ5SAMPLE0016NAME]
     *
     */
    @JSONField(name = "ibz5sample0016name")
    @JsonProperty("ibz5sample0016name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5sample0016name;

    /**
     * 属性 [IBZ5SAMPLE0016ID]
     *
     */
    @JSONField(name = "ibz5sample0016id")
    @JsonProperty("ibz5sample0016id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5sample0016id;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [IBZ5SAMPLE0014NAME]
     *
     */
    @JSONField(name = "ibz5sample0014name")
    @JsonProperty("ibz5sample0014name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5sample0014name;

    /**
     * 属性 [IBZ5SAMPLE0015NAME]
     *
     */
    @JSONField(name = "ibz5sample0015name")
    @JsonProperty("ibz5sample0015name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5sample0015name;

    /**
     * 属性 [IBZ5SAMPLE0015ID]
     *
     */
    @JSONField(name = "ibz5sample0015id")
    @JsonProperty("ibz5sample0015id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5sample0015id;

    /**
     * 属性 [IBZ5SAMPLE0014ID]
     *
     */
    @JSONField(name = "ibz5sample0014id")
    @JsonProperty("ibz5sample0014id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5sample0014id;


    /**
     * 设置 [IBZ5SAMPLE0016NAME]
     */
    public void setIbz5sample0016name(String  ibz5sample0016name){
        this.ibz5sample0016name = ibz5sample0016name ;
        this.modify("ibz5sample0016name",ibz5sample0016name);
    }

    /**
     * 设置 [IBZ5SAMPLE0015ID]
     */
    public void setIbz5sample0015id(String  ibz5sample0015id){
        this.ibz5sample0015id = ibz5sample0015id ;
        this.modify("ibz5sample0015id",ibz5sample0015id);
    }

    /**
     * 设置 [IBZ5SAMPLE0014ID]
     */
    public void setIbz5sample0014id(String  ibz5sample0014id){
        this.ibz5sample0014id = ibz5sample0014id ;
        this.modify("ibz5sample0014id",ibz5sample0014id);
    }


}


