package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBZ5Sample0013DTO]
 */
@Data
public class IBZ5Sample0013DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBZ5SAMPLE0013ID]
     *
     */
    @JSONField(name = "ibz5sample0013id")
    @JsonProperty("ibz5sample0013id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5sample0013id;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [IBZ5SAMPLE0013NAME]
     *
     */
    @JSONField(name = "ibz5sample0013name")
    @JsonProperty("ibz5sample0013name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5sample0013name;

    /**
     * 属性 [AMOUNT]
     *
     */
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private Double amount;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [QUANTITY]
     *
     */
    @JSONField(name = "quantity")
    @JsonProperty("quantity")
    private Integer quantity;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [IBZ5UNIPRODUCTNAME]
     *
     */
    @JSONField(name = "ibz5uniproductname")
    @JsonProperty("ibz5uniproductname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5uniproductname;

    /**
     * 属性 [IBZ5SAMPLE0012NAME]
     *
     */
    @JSONField(name = "ibz5sample0012name")
    @JsonProperty("ibz5sample0012name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5sample0012name;

    /**
     * 属性 [UNITPRICE]
     *
     */
    @JSONField(name = "unitprice")
    @JsonProperty("unitprice")
    private Double unitprice;

    /**
     * 属性 [UNIT]
     *
     */
    @JSONField(name = "unit")
    @JsonProperty("unit")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String unit;

    /**
     * 属性 [IBZ5SAMPLE0012ID]
     *
     */
    @JSONField(name = "ibz5sample0012id")
    @JsonProperty("ibz5sample0012id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5sample0012id;

    /**
     * 属性 [IBZ5UNIPRODUCTID]
     *
     */
    @JSONField(name = "ibz5uniproductid")
    @JsonProperty("ibz5uniproductid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5uniproductid;


    /**
     * 设置 [IBZ5SAMPLE0013NAME]
     */
    public void setIbz5sample0013name(String  ibz5sample0013name){
        this.ibz5sample0013name = ibz5sample0013name ;
        this.modify("ibz5sample0013name",ibz5sample0013name);
    }

    /**
     * 设置 [QUANTITY]
     */
    public void setQuantity(Integer  quantity){
        this.quantity = quantity ;
        this.modify("quantity",quantity);
    }

    /**
     * 设置 [IBZ5SAMPLE0012ID]
     */
    public void setIbz5sample0012id(String  ibz5sample0012id){
        this.ibz5sample0012id = ibz5sample0012id ;
        this.modify("ibz5sample0012id",ibz5sample0012id);
    }

    /**
     * 设置 [IBZ5UNIPRODUCTID]
     */
    public void setIbz5uniproductid(String  ibz5uniproductid){
        this.ibz5uniproductid = ibz5uniproductid ;
        this.modify("ibz5uniproductid",ibz5uniproductid);
    }


}


