package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBZ5Sample0009DTO]
 */
@Data
public class IBZ5Sample0009DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [KP]
     *
     */
    @JSONField(name = "kp")
    @JsonProperty("kp")
    private BigDecimal kp;

    /**
     * 属性 [IBZ5SAMPLE0009NAME]
     *
     */
    @JSONField(name = "ibz5sample0009name")
    @JsonProperty("ibz5sample0009name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5sample0009name;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [PG]
     *
     */
    @JSONField(name = "pg")
    @JsonProperty("pg")
    private BigDecimal pg;

    /**
     * 属性 [TJ]
     *
     */
    @JSONField(name = "tj")
    @JsonProperty("tj")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String tj;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [SP]
     *
     */
    @JSONField(name = "sp")
    @JsonProperty("sp")
    private BigDecimal sp;

    /**
     * 属性 [IBZ5SAMPLE0009ID]
     *
     */
    @JSONField(name = "ibz5sample0009id")
    @JsonProperty("ibz5sample0009id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5sample0009id;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [SPMC]
     *
     */
    @JSONField(name = "spmc")
    @JsonProperty("spmc")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String spmc;

    /**
     * 属性 [DATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "date" , format="yyyy-MM-dd")
    @JsonProperty("date")
    private Timestamp date;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [PD]
     *
     */
    @JSONField(name = "pd")
    @JsonProperty("pd")
    private BigDecimal pd;


    /**
     * 设置 [KP]
     */
    public void setKp(BigDecimal  kp){
        this.kp = kp ;
        this.modify("kp",kp);
    }

    /**
     * 设置 [IBZ5SAMPLE0009NAME]
     */
    public void setIbz5sample0009name(String  ibz5sample0009name){
        this.ibz5sample0009name = ibz5sample0009name ;
        this.modify("ibz5sample0009name",ibz5sample0009name);
    }

    /**
     * 设置 [PG]
     */
    public void setPg(BigDecimal  pg){
        this.pg = pg ;
        this.modify("pg",pg);
    }

    /**
     * 设置 [SP]
     */
    public void setSp(BigDecimal  sp){
        this.sp = sp ;
        this.modify("sp",sp);
    }

    /**
     * 设置 [SPMC]
     */
    public void setSpmc(String  spmc){
        this.spmc = spmc ;
        this.modify("spmc",spmc);
    }

    /**
     * 设置 [DATE]
     */
    public void setDate(Timestamp  date){
        this.date = date ;
        this.modify("date",date);
    }

    /**
     * 设置 [PD]
     */
    public void setPd(BigDecimal  pd){
        this.pd = pd ;
        this.modify("pd",pd);
    }


}


