package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBZ5Sample0003DTO]
 */
@Data
public class IBZ5Sample0003DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [FIELD01]
     *
     */
    @JSONField(name = "field01")
    @JsonProperty("field01")
    @Size(min = 0, max = 4000, message = "内容长度必须小于等于[4000]")
    private String field01;

    /**
     * 属性 [MEMO]
     *
     */
    @JSONField(name = "memo")
    @JsonProperty("memo")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    private String memo;

    /**
     * 属性 [IBZ5SAMPLE0003NAME]
     *
     */
    @JSONField(name = "ibz5sample0003name")
    @JsonProperty("ibz5sample0003name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5sample0003name;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [IBZ5SAMPLE0003ID]
     *
     */
    @JSONField(name = "ibz5sample0003id")
    @JsonProperty("ibz5sample0003id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5sample0003id;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [PIBZ5SAMPLE0003NAME]
     *
     */
    @JSONField(name = "pibz5sample0003name")
    @JsonProperty("pibz5sample0003name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String pibz5sample0003name;

    /**
     * 属性 [PIBZ5SAMPLE0003ID]
     *
     */
    @JSONField(name = "pibz5sample0003id")
    @JsonProperty("pibz5sample0003id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String pibz5sample0003id;


    /**
     * 设置 [FIELD01]
     */
    public void setField01(String  field01){
        this.field01 = field01 ;
        this.modify("field01",field01);
    }

    /**
     * 设置 [MEMO]
     */
    public void setMemo(String  memo){
        this.memo = memo ;
        this.modify("memo",memo);
    }

    /**
     * 设置 [IBZ5SAMPLE0003NAME]
     */
    public void setIbz5sample0003name(String  ibz5sample0003name){
        this.ibz5sample0003name = ibz5sample0003name ;
        this.modify("ibz5sample0003name",ibz5sample0003name);
    }

    /**
     * 设置 [PIBZ5SAMPLE0003ID]
     */
    public void setPibz5sample0003id(String  pibz5sample0003id){
        this.pibz5sample0003id = pibz5sample0003id ;
        this.modify("pibz5sample0003id",pibz5sample0003id);
    }


}


