package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBZ5CustomerMGDTO]
 */
@Data
public class IBZ5CustomerMGDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CUSTOMERUID]
     *
     */
    @JSONField(name = "customeruid")
    @JsonProperty("customeruid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String customeruid;

    /**
     * 属性 [BANKNAME]
     *
     */
    @JSONField(name = "bankname")
    @JsonProperty("bankname")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String bankname;

    /**
     * 属性 [ADDRESS]
     *
     */
    @JSONField(name = "address")
    @JsonProperty("address")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String address;

    /**
     * 属性 [IBZ5CUSTOMERID]
     *
     */
    @JSONField(name = "ibz5customerid")
    @JsonProperty("ibz5customerid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibz5customerid;

    /**
     * 属性 [IBZ5CUSTOMERNAME]
     *
     */
    @JSONField(name = "ibz5customername")
    @JsonProperty("ibz5customername")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibz5customername;

    /**
     * 属性 [BANKACCOUNTNUM]
     *
     */
    @JSONField(name = "bankaccountnum")
    @JsonProperty("bankaccountnum")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String bankaccountnum;



}


