/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'ibizuniproductid',
          prop: 'ibizuniproductid',
          dataType: 'PICKUP',
        },
        {
          name: 'ibizorderid',
          prop: 'ibizorderid',
          dataType: 'PICKUP',
        },
        {
          name: 'ibizordername',
          prop: 'ibizordername',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizorderdetailname',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'ibizorderdetailid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizorderdetailid',
          dataType: 'GUID',
        },
        {
          name: 'amount',
          prop: 'amount',
          dataType: 'FLOAT',
        },
        {
          name: 'ibizuniproductname',
          prop: 'ibizuniproductname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'unit',
          prop: 'unit',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'unitprice',
          prop: 'unitprice',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'quantity',
          prop: 'quantity',
          dataType: 'INT',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'ibizorderdetailid',
          prop: 'ibizorderdetailid',
          dataType: 'GUID',
        },
        {
          name: 'ibizorderdetail',
          prop: 'ibizorderdetailid',
        },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}