import { PanelDetailModel } from './panel-detail';

/**
 * 按钮模型
 *
 * @export
 * @class PanelButtonModel
 * @extends {PanelDetailModel}
 */
export class PanelButtonModel extends PanelDetailModel {

    /**
     * 按钮对应的界面行为
     *
     * @type {*}
     * @memberof PanelButtonModel
     */
    public uiAction: any;

    /**
     * 图标方向
     *
     * @type {('LEFT' | 'TOP' | 'RIGHT' | 'BOTTOM')}
     * @memberof PanelButtonModel
     */
    public iconAlign: 'LEFT' | 'TOP' | 'RIGHT' | 'BOTTOM';

    /**
     * 是否禁用
     *
     * @type {boolean}
     * @memberof PanelButtonModel
     */
    public disabled: boolean = false;

    /**
     * @description 按钮类型
     * @type {string}
     * @memberof PanelButtonModel
     */
    public buttonStyle: 'DEFAULT' | 'INVERSE' | 'PRIMARY' | 'INFO' | 'SUCCESS' | 'WARNING' | 'DANGER' | 'STYLE2' | 'STYLE3' | 'STYLE4';

    /**
     * @description 绘制模式
     * @type {string}
     * @memberof PanelButtonModel
     */
    public renderMode: 'BUTTON' | 'LINK';

    /**
     * 边框样式
     *
     * @type {('NONE' | 'SOLID' | 'DOTTED' | 'DASHED' | 'DOUBLE')}
     * @memberof PanelButtonModel
     */
    public borderStyle: 'NONE' | 'SOLID' | 'DOTTED' | 'DASHED' | 'DOUBLE' = 'NONE';

    /**
     * Creates an instance of PanelButtonModel.
     * @param {*} [opts={}]
     * @memberof PanelButtonModel
     */
    constructor(opts: any = {}) {
        super(opts);
        this.uiAction = opts.uiAction;
        this.buttonStyle = opts.buttonStyle;
        this.renderMode = opts.renderMode;
        this.iconAlign = opts.iconAlign || 'LEFT';
        this.disabled = opts.disabled;
        this.borderStyle = opts.borderStyle ? opts.borderStyle : 'NONE';
    }

    /**
     * 获取元素样式（按钮元素，包含内容盒子 大小/边距/边框 的样式）
     *
     * @memberof PanelButtonModel
     */
    public getElementStyle() {
        const elementStyle = {};
        Object.assign(elementStyle, this.getBoxSizeStyle());
        Object.assign(elementStyle, this.getBoxSpacingStyle());
        Object.assign(elementStyle, this.getBoxBorderStyle());
        Object.assign(elementStyle, this.getBoxSelfAlignStyle());
        return elementStyle;
    }

    /**
     * 获取盒子边框样式（元素）
     *
     * @memberof PanelButtonModel
     */
    protected getBoxBorderStyle() {
        const boxStyle = {};
        if (this.borderStyle !== 'NONE') {
            switch (this.borderStyle) {
                // 实线边框
                case 'SOLID':
                    Object.assign(boxStyle, { 'border-style': 'solid' });
                    break;
                // 点状边框
                case 'DOTTED':
                    Object.assign(boxStyle, { 'border-style': 'dotted' });
                    break;
                // 虚线边框
                case 'DASHED':
                    Object.assign(boxStyle, { 'border-style': 'dashed' });
                    break;
                // 双线边框
                case 'DOUBLE':
                    Object.assign(boxStyle, { 'border-style': 'double' });
                    break;
                default:
                    console.warn(`${this.borderStyle}暂未支持`);
                    break;
            }
        }
        return boxStyle;
    }

}